#!/bin/sh
# A menu driven shell script sample template 
## ----------------------------------
# Step #1: Define variables
# ----------------------------------
EDITOR=vim
PASSWD=/etc/passwd
RED='\033[0;41;30m'
STD='\033[0;0;39m'
 
# ----------------------------------
# Step #2: User defined function
# ----------------------------------
pause(){
  read -p "Press [Enter] key to continue..." fackEnterKey
}
 
test_update(){
	echo "Run Update Test"
	read -p "Enter Channel number and Press [Enter] " ch
	./test_update_hd.sh $ch
        pause
}
 

new_update(){
	echo "Run Fast Update"
	read -p "Enter Channel number and Press [Enter] " ch        
	./fast_update_hd.sh $ch
        pause
}
 
old_update(){
	echo "Run Slow Update"
	read -p "Enter Channel number and Press [Enter] " ch
	./slow_update_hd.sh $ch
        pause
}

exit_loop(){
	read -p "Clean tmp dir Yes/No " ans
	clean=0
	if [ "$ans" == "Yes" ]
	then 
	  clean=1
	else if [ "$ans" == "yes" ]
	then 
	  clean=1
	else if [ "$ans" == "Y" ]
	then 
	  clean=1
	else if [ "$ans" == "y" ]
	then 
	  clean=1
	fi
	fi
	fi
	fi
    
  if test $clean -eq 1
  then
    rm /home/yair/new_hd_version.tar.gz
	  rm /home/yair/tmp/*.tar.gz
  fi
	exit
}

# function to display menus
show_menus() {
#	clear
        echo ""
	echo "~~~~~~~~~~~~~~~~~~~~~"	
	echo " M A I N - M E N U"
	echo "~~~~~~~~~~~~~~~~~~~~~"
	echo "1. Check fast f/w update support"
	echo "2. Run fast f/w update"
	echo "3. Run slow f/w update"
	echo "4. Exit"
}
# read input from the keyboard and take a action
# invoke the one() when the user select 1 from the menu option.
# invoke the two() when the user select 2 from the menu option.
# Exit when user the user select 3 form the menu option.
read_options(){
	local choice
	read -p "Enter choice [ 1 - 4] " choice
	case $choice in
		1) test_update ;;
		2) new_update ;;
		3) old_update ;;
		4) exit_loop ;;
		*) echo -e "${RED}Error...${STD}" && sleep 2
	esac
}
 
# ----------------------------------------------
# Step #3: Trap CTRL+C, CTRL+Z and quit singles
# ----------------------------------------------
trap '' SIGINT SIGQUIT SIGTSTP
 
# -----------------------------------
# Step #4: Main logic - infinite loop
# ------------------------------------
while true
do
 
	show_menus
	read_options
done

