// JavaScript Document
//TS stream data xml;
var analyzeData;
//referance to the tree object
var tree;
var tsParamsData;
var droppedDataArr= new Array();;

var treeTotalsBr = new Object();
var isConfigured = false;
var countDisabled;
var adSelectedRow = null;
var adIsOverRow = false;
var programsNameArr;

// state machine description lockated on "Add & Drop State Machine.doc"
var currentState;
function clearState2(){
	currentState = 2;
	clearTree();
	clearAddDropTable();
	clearTotalAvailableBR();
	droppedDataArr = new Array();
	disableButtons(true);
	//enableButton("btnAnalyze");
	
	
}

function clearState5(){
	
	currentState = 5;
	clearTotalAvailableBR();
	disableButtons(true);
	enableButton("btnSetBitrate");
	enableButton("btnAnalyze");
	enableButton("btnClear");
	enableButton("btnAdd");
	
}

function clearState8(){
	currentState = 8;
	disableButtons(true);
	enableButton("btnSetBitrate");
	enableButton("btnConfigure");
	enableButton("btnAnalyze");
	enableButton("btnClear");
	enableButton("btnAdd");
	
}

function clearState10(){
	currentState = 10;
	disableButtons(false);
	
}

//simply reload the html with no data
function clearTree(){
	if(tree==null){
		return;
	}else{
		if (window.navigator.userAgent.indexOf("MSIE") > -1) 
			document.frames["treeFrame"].clear();
				else
			tree = document.getElementById('treeFrame').contentWindow.clear();		
	}
}

function clearTotalAvailableBR(){
	document.forms["streamFrm"].dropTotalAvailableBR.value="";
}

//get the in_ts_params
function getTS(){
	clearTree();
	clearFrmStream();
	showPopWin("<p>DVIS Loading Configuration ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
	doGetRequest(serviceURL+settingsFolder+"in_ts_params.ini",handleTS);

}

function handleTS(){
	
	var responseData = checkRequestStatus();
	if(responseData==null) return;	
	tsParamsData = new Object();
	tsParamsData = doParse(responseData);
	//pre build
	var frmObj = document.forms["formDmod"];
	//frmObj.demodModulation.value = tsParamsData.demodModulation;
	fillForm(frmObj,tsParamsData);
	demodModulation_changeHandler(frmObj.demodModulation);
	frmObj.demodSymbolRate.disabled = true;
	hidePopWin();
	getTreeReference("getAddDrop")
	//getAddDrop();
	
	
}


function demodModulation_changeHandler(selectObj){		
	var demodModulationValue = selectObj.value;	
	
	var demodModeValue;
	if(selectObj.form.demodMode.value!=""){		
		demodModeValue = selectObj.form.demodMode.value
	}else{
		demodModeValue = tsParamsData.demodMode;
	}
	
	removeOptions(selectObj.form.demodMode);
	
	if(demodModulationValue==1){
		insertOption(selectObj.form.demodMode,{name:"16",value:16});
		insertOption(selectObj.form.demodMode,{name:"32",value:32});
		insertOption(selectObj.form.demodMode,{name:"64",value:64});
		insertOption(selectObj.form.demodMode,{name:"128",value:128});
		insertOption(selectObj.form.demodMode,{name:"256",value:256});
		
		selectObj.form.demodSymbolRate.disabled = false;
		//restore pre
		selectObj.form.demodMode.value = demodModeValue;
	}else{
		insertOption(selectObj.form.demodMode,{name:"64",value:64});
		insertOption(selectObj.form.demodMode,{name:"256",value:256});
		selectObj.form.demodSymbolRate.disabled = true;
		//restore pre
		selectObj.form.demodMode.value = demodModeValue;
		if(demodModeValue == 64){
			selectObj.form.demodSymbolRate.value = 5056;
		}else if(demodModeValue == 256){
			selectObj.form.demodSymbolRate.value = 5360;
		}
	}	
	
	
	
}

//get a reference to the tree iframe object
function getTreeReference(callback){
	if (window.navigator.userAgent.indexOf("MSIE") > -1) 
		tree = document.frames["treeFrame"].tree;
	else
		tree = document.getElementById('treeFrame').contentWindow.tree;		
	if(tree==null){		
		window.setTimeout(getTreeReference,100)
		return;
	}
	//we have a refrence lets continue load flow
	eval(callback + "()");
}

function getAddDrop(){
	doGetRequest(serviceURL+settingsFolder+"adddrop.ini",handleAddDrop);
}

// Add Drop INI Data handler
function handleAddDrop(){
	var responseData = checkRequestStatus();
	if(responseData==null){
		clearState2();
		return;
	}
	
	// initiate program name array for "custom" added program
	programsNameArr = new Array();
	//___ get dropTotalAvailableBR from response
	var startIndex = responseData.indexOf("dropTotalAvailableBR");
	//if param not found clear
	if(startIndex==-1){
		clearState2();
		return;
	}		
	var endIndex = responseData.indexOf("\n",startIndex);
	if(endIndex==-1)
		endIndex=responseData.length
	var dropTotalAvailableBR =  responseData.substring(startIndex,endIndex);
	dropTotalAvailableBR = dropTotalAvailableBR.split("=")[1];
	document.forms["streamFrm"].dropTotalAvailableBR.value = dropTotalAvailableBR;
	//_______________________________________________
	droppedDataArr = iniToArrayObject(responseData,"[");
	isConfigured=true;
	//note array port data start from position one 
	
	if(droppedDataArr.length>0){
		droppedDataArr.remove(0);
		
	}
	var pidCount;
	for(var i=0;i<droppedDataArr.length;i++){
		//custom added programs special case: addProgram to dropProgram attributes
		if(droppedDataArr[i].addProgram!=null){
			droppedDataArr[i].isDropable = "9";
			droppedDataArr[i].dropProgram = droppedDataArr[i].addProgram;
			programsNameArr.push(droppedDataArr[i].dropProgram);
			continue;
		}
			
		pidCount = parseFloat(droppedDataArr[i].pidCount);
		droppedDataArr[i].pidArr = new Array (pidCount);
		for(var x=0;x<pidCount;x++){
			droppedDataArr[i].pidArr[x] = droppedDataArr[i]["pid"+x]; 
		}
	}
	setAddDrop();
	//showPopWin("<p>"+responseData+"</p>", 250, 120, null,null,"Info.");
	getTreeXML();
}

function getTreeXML(){
	//showPopWin("<p>DVIS loading configuration ..<br> Please wait.</p>", 250, 120, null,null,"Info.");
	doGetRequest(serviceURL+settingsFolder+"ts_xml_info.xml",handleGetTreeXML);
	
}


//response XML from existing file
function handleGetTreeXML(){
	var responseData = checkRequestStatus(true);	
	if(responseData==null) return;
	
	if(responseData=="" || responseData==null){
		clearState2();
		
		return;
	}
	//get tree reference
	if (window.navigator.userAgent.indexOf("MSIE") > -1) 
		tree = document.frames["treeFrame"].tree;
	else
		tree = document.getElementById('treeFrame').contentWindow.tree;		
	if(tree==null){		
		window.setTimeout(handleGetTreeXML,100)
		return;
	}
	//show tree
	parseDataToTree(responseData);
	//state4 indication
	
	if(droppedDataArr.length>0){
		 updateTreeView();
		 clearState8();
	}
}

//show dropped programs : reflacte the adddrop.ini droped prog. in tree view
function updateTreeView(){	
	var allItemsArr = tree.getSubItems(1).split(",");
	var itemText;
	var checkedProgram;
	for(var i=0;i<allItemsArr.length;i++){
		if(allItemsArr[i].indexOf("null")==-1)	{
			itemText = tree.getItemText(allItemsArr[i]).toLowerCase();
			if(itemText.indexOf("program")>-1){
				checkedProgram = Number(trim(itemText.split("=")[1]));
				for(var x=0;x<droppedDataArr.length;x++){					
					droppedDataArr[x].dropProgram =droppedDataArr[x].dropProgram;
					droppedDataArr[x].dropProgram=Number(droppedDataArr[x].dropProgram);
					
					if(droppedDataArr[x].dropProgram==checkedProgram){
						droppedDataArr[x].id = allItemsArr[i];
						document.getElementById('treeFrame').contentWindow.setNodeState(false,allItemsArr[i],false);
						break;
					}
				}
			}
		}
	}

	
}

//validation function for setBitrate use
function isAVChannelDuplicated(){
	var frmObj = document.forms["addDropSettings"];	
	var itemsCount =droppedDataArr.length;
	for (var i=0; i < itemsCount;i++){
		if(droppedDataArr[i].addAV == 0) continue;
		for (var x=0;x < itemsCount;x++){
			if(droppedDataArr[i].addAV == 0) continue;
			if(x==i) continue;
			if(droppedDataArr[i].addAV==droppedDataArr[x].addAV){				
				return true;
			}
		}
	}
	return false;
}

function isProgramNameValid(){
	var itemsCount =droppedDataArr.length;
	for (var i=0; i < itemsCount;i++){
		if(droppedDataArr[i].isDropable != "9") continue;
		if(!isNumeric(droppedDataArr[i].dropProgram)) 
			return false;		
		for (var x=0;x < itemsCount;x++){
			if(droppedDataArr[i].isDropable != "9") continue;
			if(x==i) continue;
			if(droppedDataArr[i].dropProgram==droppedDataArr[x].dropProgram){				
				return false;
			}
		}
	}
	return true;
	
}

//validation function for setBitrate use
function isVideoBitrateRangesValid(){
	var frmObj = document.forms["addDropSettings"];	
	var vid_br,aud_br;
	for (var i=1;i<=droppedDataArr.length;i++){
		vid_br = frmObj["addVideoBR"+i].value;
		aud_br = frmObj["addAudioBR"+i].value;
		if(vid_br==0 && aud_br==0) 
			continue;
		if(!isValueBetween(vid_br,1000, 15000))
			return false;
	}
	return true;
	
}

function sendSetBitrate(){
	
	if(droppedDataArr.length==0){
		showPopWin("<p>DVIS Add Drop Set Bit Rates require at least one AV channel.</p>", 250, 120, null,true,"Info.");
		clearState5();
		return;
	}
	
	showPopWin("<p>DVIS Add Drop Set Bit Rates in progress.. <br> Note: Analyze process may take more than one minute.</p><div id='pbPH'></div>", 250, 140, null,null,"Info.",true);
	var contentDocument;
	if (window.navigator.userAgent.indexOf("MSIE") > -1){
		contentDocument = document.frames["popupFrame"].document;		
	}else{
		contentDocument = document.getElementById("popupFrame").contentDocument;		
	}
	timeBarInit(contentDocument);
	doPostRequest(postURL+"?set_br_operation",buildSetBitrateParams(),handleSetBitrate);
}

function handleSetBitrate(){
	var responseData = checkRequestStatus();
	if(responseData==null) return;
	progress_bar_active = false;
	hidebar();
	brData = new Object();
	brData = doParse(responseData);	
	if(brData.dropTotalAvailableBR == 0){
		showPopWin("<p>There is mismatch between In&Out bit-rates settings , please check in/out modulation modes and symbol rates.</p>", 250, 120, null,true,"Info.");
		return;	
	}
	document.forms["streamFrm"].dropTotalAvailableBR.value = brData.dropTotalAvailableBR;
	isConfigured = false;
	var activeAV=0;
	for (var i=0;i<droppedDataArr.length;i++){
		if(droppedDataArr[i].addAV==0) continue;
		activeAV++;
	}
	
	for (var i=0;i<droppedDataArr.length;i++){
		if(droppedDataArr[i].addAV==0) continue;
		droppedDataArr[i].addAudioBR = 128;
		droppedDataArr[i].addVideoBR = parseInt((brData.dropTotalAvailableBR - activeAV*128)/activeAV) ;
		
	}
	setAddDrop();
	clearState8();
	hidePopWin();
}

function buildSetBitrateParams(){
	var pidCount=0;
	for (var i=0;i<droppedDataArr.length;i++){
		if(droppedDataArr[i].isDropable=="9")
			continue;
		pidCount+=droppedDataArr[i].pidArr.length;
	}
	var retStr = "numofpids=" + pidCount + "\n";
	pidCount=0;
	for (var i=0;i<droppedDataArr.length;i++){
		if(droppedDataArr[i].isDropable=="9")
			continue;
		for (var x=0;x<droppedDataArr[i].pidArr.length;x++){
			retStr += "pid"+pidCount+"=" + droppedDataArr[i].pidArr[x] + "\n";
			pidCount++;
		}
	}
	return retStr;
}

function sendAddDropConfigure(){
	unMarkAddDrop();
	//total free bitrate > total AV bitrate .			
	if(droppedDataArr.length!=0 && parseFloat(document.forms["addDropSettings"].addTotalAVBR.value) > parseFloat(document.forms["streamFrm"].dropTotalAvailableBR.value)){				
		markBitrateValues();
		showPopWin("<p>Total AV Bitrate exceeds available.<br>Please correct the marked values.</p>", 250, 120, null,true,"Error.");
		clearState8();
		return;
	}
	if(isAVChannelDuplicated()) {
		showPopWin("<p>Using the same AV channel for two different dropped programs is not allowed</p>", 250, 120, null,true,"Error.");	
		clearState8();
		return;
	}
	if(!isVideoBitrateRangesValid()) {
		showPopWin("<p>Video BitRate value must be between 1000 - 15000</p>", 250, 120, null,true,"Error.");	
		clearState8();
		return;
	}
	if(!isProgramNameValid()) {
		showPopWin("<p>Dropped Program must be a unique number.</p>", 250, 120, null,true,"Error.");	
		clearState8();
		return;
	}
	showPopWin("<p>DVIS Add & Drop Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
	doPostRequest(postURL+"?configure_add_drop",buildConfigureParams(),handleAddDropConfigure);
}

function buildConfigureParams(){

	var addedTotal=0;
	var addCount = 0;
	var dropCount = 0;
	for (var i=0;i<droppedDataArr.length;i++)		
		if(droppedDataArr[i].isDropable=="9")
			addedTotal++;
			
	retStr = "[config]\n";
	retStr += "addProgramNum=" + addedTotal + "\n";
	retStr += "dropProgramNum=" + String(droppedDataArr.length - addedTotal) + "\n";
	retStr += "dropTotalAvailableBR=" + document.forms["streamFrm"].dropTotalAvailableBR.value + "\n\n";
	//[drop]
	for (var i=0;i<droppedDataArr.length;i++){
		if(droppedDataArr[i].isDropable=="9")
			continue;
		retStr += "[drop" + dropCount + "]\n";
		retStr += "dropProgram=" + droppedDataArr[i].dropProgram + "\n";
		retStr += "addAV=" + droppedDataArr[i].addAV + "\n";
		if(droppedDataArr[i].addAV==0){
			retStr += "addVideoBR=0\n";
			retStr += "addAudioBR=0\n";
		}else{
			retStr += "addVideoBR=" + droppedDataArr[i].addVideoBR + "\n";
			retStr += "addAudioBR=" + droppedDataArr[i].addAudioBR + "\n";
		}
		retStr += "pidCount=" + droppedDataArr[i].pidArr.length + "\n";
		for (var x=0;x<droppedDataArr[i].pidArr.length;x++){
			retStr += "pid" + x + "=" + droppedDataArr[i].pidArr[x] + "\n";
			
		}
		retStr += "\n";
		dropCount++;
	}
	//[add]
	for (var i=0;i<droppedDataArr.length;i++){
		if(droppedDataArr[i].isDropable!="9")
			continue;
		retStr += "[add" + addCount + "]\n";
		retStr += "addProgram=" + droppedDataArr[i].dropProgram + "\n";
		retStr += "addAV=" + droppedDataArr[i].addAV + "\n";
		retStr += "addVideoBR=" + droppedDataArr[i].addVideoBR + "\n";
		retStr += "addAudioBR=" + droppedDataArr[i].addAudioBR + "\n";
		retStr += "\n";
		addCount++;
	}
	
	return retStr;
}

function handleAddDropConfigure(){
	var responseData = checkRequestStatus();
	if(responseData==null) return;	
	isConfigured = true;
	clearState10();
	hidePopWin();
}

function sendAddDropStart(){
	
	showPopWin("<p>DVIS Start Mux In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);	
	doPostRequest(postURL+"?start_mux_operation","",handleAddDropStart);
}

function handleAddDropStart(){
	var responseData = checkRequestStatus();
	if(responseData==null) return;
	clearState10();
	hidePopWin();
}
 
function sendAnalyze(){
	
	var frmObj = document.getElementById("formDmod");
	var setDmod = new Object();
	if(!validateForm(frmObj,"Dmod")) return;
	setDmod.demodFreq=frmObj.demodFreq.value;
	setDmod.demodMode= frmObj.demodMode.value;
	setDmod.demodSymbolRate= frmObj.demodSymbolRate.value;			
	setDmod.demodModulation= frmObj.demodModulation.value;			
	var postStr = objectToPostString(setDmod);
	showPopWin("<p>DVIS Analyze In Progress ..<br> Note: Analyze process may take more than one minute.</p><div id='pbPH'></div>", 250, 140, null,null,"Info.",true);	
	var contentDocument;
	if (window.navigator.userAgent.indexOf("MSIE") > -1){
		contentDocument = document.frames["popupFrame"].document;		
	}else{
		contentDocument = document.getElementById("popupFrame").contentDocument;		
	}	
	timeBarInit(contentDocument);
	clearTree();
	clearTotalAvailableBR();
	droppedDataArr = new Array();
	programsNameArr = new Array();
	clearAddDropTable();
	disableButtons(true);
	enableButton("btnAnalyze")
	doPostRequest(postURL+"?start_demod_analyze",postStr,handleAnalyze);
	
}
function clearFrmStream(){
	document.forms["streamFrm"].sID.value="";
	//document.forms["streamFrm"].totalDroppednNull.value="";
	document.forms["streamFrm"].dropTotalAvailableBR.value="";
	document.forms["streamFrm"].totalBR.value="";
	var treeTotalsBr = new Object();
	
}

function handleAnalyze(){
	var responseData = checkRequestStatus();
	if(responseData==null) return;
	isConfigured=false;
	progress_bar_active = false;
	hidebar();
	//get tree reference
	if (window.navigator.userAgent.indexOf("MSIE") > -1) 
		tree = document.frames["treeFrame"].tree;
	else
		tree = document.getElementById('treeFrame').contentWindow.tree;		
	if(tree==null){		
		window.setTimeout(handleAnalyze,100)
		return;
	}
	parseDataToTree(responseData);
	enableButton("btnAdd");
}

function parseDataToTree(analyzeData){
	tree.loadXMLString(analyzeData);
	if(tree.getSubItems(0)==""){
		showPopWin("<p>Incorrect XML.<br> Please reAnalyze.</p>", 250, 120, null,true,"Error.");
		return;
	}
	setTreeIcons();
	treeTotalsBr = new Object();
	//get ts id
	var itemText;
	var tempItemsArr = tree.getSubItems(1).split(",");
	for(var i=0;i<tempItemsArr.length;i++){
		itemText = tree.getItemText(tempItemsArr[i]).toLowerCase();
		if(itemText.indexOf("ts id")>-1){
			document.forms["streamFrm"].sID.value = itemText.split("=")[1];
			break;
		}
	}
	//get sub items from the root:totals
	tempItemsArr = tree.getSubItems(0).split(",");
	for(i=0;i<tempItemsArr.length;i++){
		itemText = tree.getItemText(tempItemsArr[i]).toLowerCase();
		if(itemText.indexOf("null packets bitrate")>-1){
			treeTotalsBr.dropped_nulls = parseFloat(itemText.split("=")[1].split("kbps")[0]);
			//document.forms["streamFrm"].totalDroppednNull.value = treeTotalsBr.dropped_nulls;
			
		}else if(itemText.indexOf("transport stream total bitrate")>-1){
			treeTotalsBr.totalBR = parseFloat(itemText.split("=")[1].split("kbps")[0]);
			document.forms["streamFrm"].totalBR.value = treeTotalsBr.totalBR;
		}else if(itemText.indexOf("margin")>-1){
			treeTotalsBr.marginBR = parseFloat(itemText.split("=")[1].split("kbps")[0]);
			
		}
	}
	hidePopWin();
}

function setTreeIcons(){			
	//open all programs
	tree.openAllItems(0);
	//tree.setItemImage2(0,"TV.jpg","TV.jpg","TV.jpg");
	//var x = tree._globalIdStorageFind(0);
	
	var allItemsArr = tree.getSubItems(1).split(",");
	var subItemsArr;
	var itemNode;
	
	for(var i=0;i<allItemsArr.length;i++){
		if(allItemsArr[i].indexOf("null")==-1)	{
			itemNode = tree._globalIdStorageFind(allItemsArr[i]);				
			
			//tree.setOnClickHandler(ah);
			tree.setItemImage(allItemsArr[i],"P.jpg","P.jpg");
			//fold program childes 
			tree.closeAllItems(allItemsArr[i]);
			programsNameArr.push(tree.getItemText(allItemsArr[i]).split("=")[1]);
			subItemsArr =  tree.getSubItems(allItemsArr[i]).split(",");
			for(var x=0;x<subItemsArr.length;x++){
		
					itemNode = tree._globalIdStorageFind(subItemsArr[x]);
					
					if(itemNode.params==null)
						continue;
					if(itemNode.params.estype=="1"){
						tree.setItemImage(subItemsArr[x],"Film.jpg","Film.jpg");
					}
					else if(itemNode.params.estype=="2"){
						tree.setItemImage(subItemsArr[x],"Audio.jpg","Audio.jpg");
					}
					else if(itemNode.params.estype=="3"){
						tree.setItemImage(subItemsArr[x],"PSI.jpg","PSI.jpg");
					}
					else if(itemNode.params.estype=="0"){
						tree.setItemImage(subItemsArr[x],"QM.jpg","QM.jpg");
					}else if(itemNode.label.toLowerCase().indexOf("program bitrate")>-1)
						tree.setUserData(allItemsArr[i],"isdropable",itemNode.params.isdropbale)
					tree.setItemChangeable(allItemsArr[i],"1");
			}
		}
	
	}
	countDisabled =0;				
}



//create html items of add drop div from data
function setAddDrop(){	
	clearAddDropTable();
	var frmObj = document.forms["addDropSettings"];
	var container = document.getElementById("dropContainer");
	var dropStr="";
	for (var i=0;i<droppedDataArr.length;i++){
		dropStr+=addDropRow(i+1,droppedDataArr[i]);
	}
	container.innerHTML = dropStr;
	
	calcAddDropTotal(true);
	
	
}

function addDropRow(index,obj){
	var dropRowStr =  '<div onMouseOver="adRow_handleMouseOver(this,true);" onMouseOut="adRow_handleMouseOver(this,false);" onClick="markADRow(this)" id="row'+index+'" index="'+index+'" style="width:100%;">&nbsp;';
	
	if(obj.isDropable == "9"){
		dropRowStr += '<input name="dropProgram'+index+'" value="'+obj.dropProgram+'" type="text" class="textBox" id="dropProgram'+index+'" style="width:60px;" maxlength="5" onKeyUp="setProgramName('+index+')" onChange="setProgramName('+index+')"/>&nbsp;&nbsp;';
	}else{
		dropRowStr += '<input name="dropProgram'+index+'" value="'+obj.dropProgram+'" readonly type="text" class="textBox" id="dropProgram'+index+'" style="width:60px;" />&nbsp;&nbsp;';
	}
	
	dropRowStr += '<select onChange="addAV_change(this,'+(index-1)+')" name="addAV'+index+'" id="addAV'+index+'" class="optionBox" style="width:60px;" >'
	
    if(obj.isDropable =="0")
		dropRowStr += '<option value="0" selected>None</option>';
	else if(obj.isDropable =="9"){		
		for (var i=1;i <= portCount;i++)
    		dropRowStr += (obj.addAV==i)? '<option value="' + i + '" selected>AV' + i + '</option>':'<option value="' + i + '" >AV' + i + '</option>';
    	
	}else {
		dropRowStr += (obj.addAV==0)? '<option value="0" selected>None</option>':'<option value="0" >None</option>';
		for (var i=1;i <= portCount;i++)
    		dropRowStr += (obj.addAV==i)? '<option value="' + i + '" selected>AV' + i + '</option>':'<option value="' + i + '" >AV' + i + '</option>';
    	
	}
    dropRowStr += '</select>&nbsp;&nbsp;';
	if(obj.addAV==0)
    	dropRowStr += '<input name="addVideoBR'+index+'" value="0" type="text" class="textBox" id="addVideoBR'+index+'" style="width:55px;" readonly  />&nbsp;&nbsp;';
    else
		dropRowStr += '<input name="addVideoBR'+index+'" value="'+obj.addVideoBR+'" type="text" class="textBox" id="addVideoBR'+index+'" style="width:55px;" onKeyUp="calcAddDropTotal()" onChange="calcAddDropTotal()"  />&nbsp;&nbsp;';
    dropRowStr += '<select name="addAudioBR'+index+'" onChange="calcAddDropTotal()" class="optionBox" style="width:50px;" id="addAudioBR'+index+'" >&nbsp;&nbsp;';
    if(obj.addAV==0)
		dropRowStr += '<option value="0">0</option>';
	else{
		dropRowStr += (obj.addAudioBR=="192" || obj.addAudioBR=="")? '<option value="192" selected>192</option>':'<option value="192">192</option>';
		dropRowStr += (obj.addAudioBR=="256" || obj.addAudioBR=="")? '<option value="256" selected>256</option>':'<option value="256">256</option>';
    	dropRowStr += (obj.addAudioBR=="384")? '<option value="384" selected>384</option>':'<option value="384">384</option>';
	}
    dropRowStr += '</select>&nbsp;&nbsp;';
    dropRowStr += '<input name="addTotalChannelBR'+index+'" readonly type="text" class="textBox" id="addTotalChannelBR'+index+'" style="width:55px;" />';
	if(obj.isDropable =="9")
		dropRowStr += '<image align="absmiddle" src="tree/treeImgs/Pup.jpg" alt="Added Program">';	
    dropRowStr += '</div>';
	return dropRowStr;
}

// called from 'Add' button: 
// adds a custom row to add & drop without dropping any from the tree 
function adAddRow(){
	var adObj = new Object();
	adObj.dropProgram = getNextProgramName();
	programsNameArr.push(adObj.dropProgram);
	adObj.id = "added_" +adObj.dropProgram;
	adObj.addAV = 1;
	adObj.isDropable = "9";
	adObj.addAudioBR = 128;
	adObj.addVideoBR = 0;
	adObj.index = droppedDataArr.length+1;
	adObj.pidArr = new Array();
	droppedDataArr.push(adObj);
	//enableButton("btnSetBitrate");
	clearState5();
	setAddDrop();	
}

function getNextProgramName(){
	var maximum = 1; 
  	var prg;
	for (i = 0; i < programsNameArr.length; i++){
		prg = eval(programsNameArr[i]);
    	if (!isNaN(prg) && prg > maximum){
      		maximum = prg;			
		}
	}
	return maximum+1;
}

function adRemoveRow(){
	CloseContext();
	//check if program in to be activate on tree ts stream
	var adItem = droppedDataArr[adSelectedRow.getAttribute("index")-1];
	if(adItem.isDropable != "9"){
		//reactivate program in tree view
		document.getElementById('treeFrame').contentWindow.setNodeState(true,adItem.id,false);
	}
	droppedDataArr.remove(adSelectedRow.getAttribute("index")-1);
	if(droppedDataArr.length==0)
		disableButton("btnSetBitrate");
	setAddDrop();
	clearState5();
}

function markADRow(obj){
	for(var i=1;i<=droppedDataArr.length;i++){
		
		document.getElementById("row"+i).className="";	
	}
	adSelectedRow = obj
	obj.className = "adMark";	
	adIsOverRow = true;
}

//mouse over / out handler for add and drop rows
function adRow_handleMouseOver(obj,state){
	if(adSelectedRow == obj && state)
		adIsOverRow = true;
	else
		adIsOverRow = false;
	
}

//inkoved on AV drop list change
function addAV_change(obj,index){
	
	isConfigured=false
	droppedDataArr[index].addAV = obj.value;
	setAddDrop();
	if(currentState==10)
		clearState8();
	
}

function setProgramName(index){
	var frmObj = document.forms["addDropSettings"];
	droppedDataArr[index-1].dropProgram = frmObj["dropProgram"+index].value
}

//param auto: if calc is from user action disable configure
function calcAddDropTotal(auto){
	if(auto==null)
		isConfigured=false
	var frmObj = document.forms["addDropSettings"];
	var totalSum=0;
	var vidSum=0;
	var audSum=0;
	for (var i=1;i<=droppedDataArr.length;i++){
		if(droppedDataArr[i-1].addAV != 0){
			vidSum = droppedDataArr[i-1].addVideoBR = eval(frmObj["addVideoBR"+i].value);
			audSum = droppedDataArr[i-1].addAudioBR = eval(frmObj["addAudioBR"+i].value);		
			totalSum += vidSum + audSum;
			frmObj["addTotalChannelBR"+i].value =  vidSum + audSum;
		}
		
	}
	frmObj["addTotalAVBR"].value = totalSum;
}


//Add or Drop Action Tree to Table
function addDropAction(state,program){
	var itemNode;
	var itemId = tree.getSelectedItemId();
	isConfigured=false
	if(!state){
		
		var subItemsArr = tree.getSubItems(itemId).split(",");
		var tmpObj = new Object();
		tmpObj.dropProgram = trim(tree.getSelectedItemText().split("=")[1].split("(Dropped)")[0]);
		//tmpObj.dropProgram = program;
		tmpObj.id = itemId;
		var mod;
		var delta;
		var tmpValue;
		var audMod = new Array();
		tmpObj.pidArr = new Array();
	
		
		for(var i=0;i<subItemsArr.length;i++){
			
			itemNode = tree._globalIdStorageFind(subItemsArr[i]);
			
			if(itemNode.params.estype=="1"){
				if(itemNode.params.min_br!="" && itemNode.params.min_br!=null)
					tmpObj.addVideoBR = itemNode.params.min_br;
				else
					tmpObj.addVideoBR = itemNode.params.br;
				
				
			}
			else if(itemNode.params.estype=="2"){
				
				tmpObj.addAudioBR = 256
			}
			else if(itemNode.label.toLowerCase().indexOf("program bitrate")>-1){
				tmpObj.programBR = itemNode.params.br;
			}
			if(itemNode.params.pid!=null){
				tmpObj.pidArr.push(itemNode.params.pid);
				
			}
			
		}	
		var isDropable = tree.getUserData(itemId,"isdropable");	
		tmpObj.isDropable = isDropable;
		tmpObj.addAV=0;
		if(isDropable!="1"){
			tmpObj.addVideoBR = 0;
			tmpObj.addAudioBR = 0;
		}
		droppedDataArr.push(tmpObj);
		setAddDrop();		
	}else{
		for(var i= 0;i<droppedDataArr.length;i++){
			if(droppedDataArr[i].dropProgram == program){
				tmpValue = droppedDataArr[i];
				droppedDataArr.remove(i);
				setAddDrop();
				clearState5();
				return;
			}
		}				
	}
	
	clearState5();
}


//clear the graphic content of Add and Drop
function clearAddDropTable(){
	
	var frmObj = document.forms["addDropSettings"];	
	document.getElementById("dropContainer").innerHTML="";
	frmObj["addTotalAVBR"].value = "";
}

Array.prototype.remove = function(from, to){
  this.splice(from,
    !to ||
    1 + to - from + (!(to < 0 ^ from >= 0) && (to < 0 || -1) * this.length));
  return this.length;
};



function enableButton(btnName){	
	var obj = document.getElementById(btnName);
	obj.disabled = false;
	obj.className = "buttonBox";//buttonBoxDisabled
}

function disableButton(btnName){
	var obj = document.getElementById(btnName);
	obj.disabled = true;
	obj.className = "buttonBoxDisabled";
}

function disableButtons(state){
	var frmObj = document.forms["addDropSettings"];
	frmObj.btnSetBitrate.disabled  = state;
	frmObj.btnSetBitrate.className = state ? "buttonBoxDisabled":"buttonBox";
	frmObj.btnConfigure.disabled  = state;
	frmObj.btnConfigure.className = state ? "buttonBoxDisabled":"buttonBox";
	frmObj.btnStart.disabled  = state;
	frmObj.btnStart.className = state ? "buttonBoxDisabled":"buttonBox";
	frmObj.btnClear.disabled  = state;
	frmObj.btnClear.className = state ? "buttonBoxDisabled":"buttonBox";
	frmObj.btnAdd.disabled  = state;
	frmObj.btnAdd.className = state ? "buttonBoxDisabled":"buttonBox";
	document.getElementById("btnAnalyze").disabled  = state;
	document.getElementById("btnAnalyze").className = state ? "buttonBoxDisabled":"buttonBox";
	
}

function markBitrateValues(){
	var frmObj = document.forms["addDropSettings"];
	for (var i=1;i<=droppedDataArr.length;i++){
		if(frmObj["dropProgram"+i].value=="")
			return;
		markRow(frmObj["dropProgram"+i]);
	}
	
}

function unMarkAddDrop(){	
	var cell;
	for(var i=1;i<=droppedDataArr.length;i++){
		cell= document.getElementById("row"+i);
		cell.style.backgroundColor = '#FFFFFF';
	}	
	
}


function clearAddDrop(){	
	clearTotalAvailableBR();
	clearAddDropTable();
	droppedDataArr = new Array();
	disableButtons(true);
	enableButton("btnAnalyze");
	enableButton("btnAdd");
	showPopWin("<p>DVIS Loading Configuration ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
	clearTree();
	getTreeXML();
	
}

function openTunerDiagnostics(){
	disableButton("btnAnalyze");
	var formStr = '<form id="changPasswordFrm" onSubmit="window.top.callOwner(true);return false;" name="changPasswordFrm">';			
	formStr +='<label style="width:220px">QAM Modulation Type: </label>';
	formStr +='<select name="demodModulation"  id="demodModulation" class="textBox" onChange="top.demodModulation_changeHandler(this)">';
	formStr +='<option value="1">QAM-A/C</option>';
	formStr +='<option value="2">QAM-B</option>';
	formStr +='</select><br>';
	formStr +='<label style="width:220px">QAM Mode:</label>';
	formStr +='<select name="demodMode"  id="demodMode" class="textBox" onChange="top.demodModulation_changeHandler(this.form.demodModulation)">';
	formStr +=' <!-- options are dynamic by demodMoudulation value -->';
	formStr += '<option value="16">16</option>';
	formStr += '<option value="32">32</option>';
	formStr += '<option value="64">64</option>';
	formStr += '<option value="128">128</option>';
	formStr += '<option value="256">256</option>';
	formStr +='</select><br><div class="divRow">';
	formStr +='<label style="width:220px;">Channel Frequency:<span class="boundaries">';//[47000 - 897000]</span></label>';
	formStr += document.getElementById('demod_freq').innerHTML;
	formStr += '</span></label>';

	formStr +='<input name="demodFreq" type="text" class="textBox" id="demodFreq">';
	formStr +='<span class="boundaries">(Khz)</span><br></div><div class="divRow">';
	formStr +='<label style="width:220px">Symbol Rate:<span class="boundaries">[2608 - 6956]</span></label>';
	formStr +='<input name="demodSymbolRate" type="text" class="textBox" id="demodSymbolRate" />';
	formStr +='<span class="boundaries">(Ksps)</span></div>'; 
	formStr +='<div style="display:inline;">';
	formStr +='<span><label style="font-weight:bold;text-align:center;line-height:50px;width:110px;">Carier Lock<br><img id="CL_Led" src="images/red.png"></label></span>';
	formStr +='<span><label style="font-weight:bold;text-align:center;line-height:50px;width:110px;">Frame Sync<br><img id="FS_Led" src="images/red.png"></label></span>';
	formStr +='<span><label style="font-weight:bold;text-align:center;line-height:50px;width:110px;">Front End Lock<br><img id="FE_Led" src="images/red.png"></label></span>';
	formStr +='</div><br><br><br><br><br><br><br>';
	//formStr +='<label style="width:220px;font-weight:bold;">Estimate Power Level:</label>';
	//formStr +='<input name="PowerLevel" type="text" class="textBox" readonly id="PowerLevel">';
	//formStr +='<span class="boundaries">(DBmv)</span><br>';
	formStr +='<div class="divRow"><label style="width:220px;font-weight:bold;">BER:</label>';
	formStr +='<input name="BER" type="text" class="textBox" readonly id="BER" /></div>';	
	formStr +='<label id="lblError" ></label><br>';
	formStr +='</form>';
	formStr +='<div style="float:left;padding-left:60px;"><input class="buttonBox" type="button" onclick="window.top.applyDiagnosticSettings(document.forms[0])" value="Apply & Close"></div>';
	var popDocument = showFormWin(formStr, 440, 380, startDiagnosticTune,true,"Tuner Diagnostic","Tune");
	var popForm = popDocument.forms[0];
	var sourceForm = document.forms["formDmod"];
	//cop source values to pop form
	for(var i= 0;i<sourceForm.elements.length;i++){
		if(sourceForm.elements[i].type!="button")
			popForm.elements[i].value = sourceForm.elements[i].value;
	}
	
	//initiate select option 
	demodModulation_changeHandler(popForm.demodModulation);
	
}


//TODO move to page start + params description
var diagnosticDataInterval;
var setDmodPopupFrm;

function startDiagnosticTune(frmObj){	
	setDmodPopupFrm = frmObj;
	var setDmod = new Object();
	configFormDmod(frmObj);
	frmObj.BER.allowEmpty = true;
	//frmObj.PowerLevel.allowEmpty = true;
	clearMarkedPopRows();
	if(!validateForm(frmObj,"Dmod",true)) return;
	setDmod.demodFreq=frmObj.demodFreq.value;
	setDmod.demodMode= frmObj.demodMode.value;
	setDmod.demodSymbolRate= frmObj.demodSymbolRate.value;			
	setDmod.demodModulation= frmObj.demodModulation.value;			
	var postStr = objectToPostString(setDmod);
	popFormShowBusy();	
	doPostRequest(postURL+"?start_demod_diag_tune",postStr,handleDiagnosticTune);
	
}

function handleDiagnosticTune(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	if(responseData.toLowerCase().indexOf("errmsg")>-1){		
		popFormSetMessage(responseData);
		popFormHideBusy();
		return;
	}
	//init request counter	
	this.BER_COUNT = BER_OFFSET;
	getDiagnosticData();
}


function getDiagnosticData(){
	doPostRequest(postURL+"?get_demod_diag_data","",handleDiagnosticData);	
}


function handleDiagnosticData(){

	var responseData = checkRequestStatus();

	if(responseData==null) return;
	if(responseData.toLowerCase().indexOf("errmsg")>-1){		
		popFormSetMessage(responseData);		
		return;
	}
	
	var dtData = doParse(responseData);
	
	//setDmodPopupFrm.PowerLevel.value = dtData.PowerLevel;
	//BER data revealed after "config.js:BER_OFFSET" miliseconds
	setDmodPopupFrm.BER.value = (this.BER_COUNT>0) ? "Acquiring BER":dtData.BER;
	this.BER_COUNT--;
	var popDocument = getPopDocument();	
	popDocument.getElementById("CL_Led").src = (Number(dtData.CL_Led)!=1)? "images/red.png":"images/green.png";
	popDocument.getElementById("FS_Led").src = (Number(dtData.FS_Led)!=1)? "images/red.png":"images/green.png";
	popDocument.getElementById("FE_Led").src = (Number(dtData.FE_Led)!=1)? "images/red.png":"images/green.png";	
	window.clearInterval(diagnosticDataInterval);
	diagnosticDataInterval = window.setTimeout(getDiagnosticData,1000);	
}

function applyDiagnosticSettings(frmObj){
	window.clearInterval(diagnosticDataInterval);
	
	
	var dataObj = new Object();
	for (var i= 0 ; i<frmObj.elements.length;i++){
		dataObj[frmObj.elements[i].name] = frmObj.elements[i].value;
	}
	var targetForm = document.forms["formDmod"];
	
	//copy source values to pop form
	for(var i= 0;i<targetForm.elements.length;i++){
		if(targetForm.elements[i].type!="button"){
			targetForm.elements[i].value = eval(frmObj.elements[i].value);
			if(targetForm.elements[i].name == "demodModulation")
				demodModulation_changeHandler(targetForm.demodModulation);			
		}
	}
	targetForm.demodSymbolRate.disabled = true;
	if(!isNaN(eval(frmObj.BER.value))){
		enableButton("btnAnalyze");
	}
	hidePopWin();
}

function clearMarkedPopRows(){
	var rows = getPopDocument().getElementsByTagName("div");
	for(var i= 0;i<rows.length;i++){
		if(rows[i].className =="divRow")
			rows[i].style.backgroundColor = '#F2F2F2';	
	}
	popFormSetMessage("");
}