// JavaScript Document

//holds the request/response action 
var rAction="port";
//data objects
var portsData = new Array();
var portsDataDisplay = new Array();

var profileData = new Object();
var maintData = new Object();
var getStatusData = new Object();
var netData = new Object();
var gbitPortData;
//for load use

var portNum=1;
// for mark column use
var preColNumber=1;
/////////////
var get_status_interval;
var get_status_freq = 30000;

//have to global for export setting use
var availableProfiles;

//initiate data get requests for profile
function initDataRequests(){
	
	configForms();	
	document.getElementById("portNumber").selectedIndex=0;
	sendGetSleepMode();

}

function getAvailableProfiles(){
	hidePopWin();
	showPopWin("<p>DVIS Loading Configuration ..<br> Please wait.</p>", 250, 120, null,null,"Info.",true);
	doPostRequest(postURL+"?get_profiles","",handleGetAvailableProfiles);
}

function handleGetAvailableProfiles(){
	
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	availableProfiles=new Object();
	availableProfiles = doParse(responseData);
	var profilesStr=' <span class="menuLink">Profiles: </span><select name="profiles" id="profiles" class="optionBox" style="width:120px; " onChange="selectProfile(this.value)">';
	for(var i=1;i <= availableProfiles["profNumOfProfiles"];i++){
		profilesStr += '<option value="' +  i + '">' + availableProfiles["profile" + i] + '</option>';
	}
    profilesStr += '</select>';
	document.forms["profilesFrm"].innerHTML = profilesStr;
	var profileElement= document.getElementById("profiles");
	profileElement.value = eval(availableProfiles["profProfileInUse"]);
	//alert(profileElement.text)
	settingsFolder =  profileElement.options[profileElement.selectedIndex].text + "/";
	doGetProfile(false);
	
}

/*
* Load profile.ini
*<param> showMessage : boolean in use for silent refresh
*/
function doGetProfile(showMessage){
	
	if(showMessage!=false){
		showPopWin("<p>DVIS Loading Configuration ..<br> Please wait.</p>", 250, 120, null,null,"Info.",true);
	}
	doGetRequest(serviceURL+settingsFolder+"profile.ini",handleGetProfile);
}

//muxAddDropMode check box change event handler
//enable disable muxPSImonitor by muxAddDropMode state
function handle_muxAddDropMode_change(sender){	
	sender.form.muxPSImonitor.disabled = !sender.checked;
}

//enable disable menu access by profile.ini params
function setAddDropMenu(){
	//var addDropMenuItem = document.getElementById("addDropMenuItem");
	if(profileData.muxAddDropMode!=1){
		hideMenuItem("addDropMenuItem");
	}else{
		showMenuItem("addDropMenuItem","AddDrop");
	}
	//var	menuItem = document.getElementById("ipoutItem");
	if(profileData.muxOutput==1){
		hideMenuItem("ipoutItem");
	}else{
		showMenuItem("ipoutItem","IP_OUT");
	}
	//menuItem = document.getElementById("rfItem");
	if(profileData.muxOutput==2){
		hideMenuItem("rfItem");
	}else{
		showMenuItem("rfItem","RF");
	}
}

function muxOutput_change(el){
	if(el.value == "2"){
		hideMenuItem("rfItem");
	}else{
		showMenuItem("rfItem","RF");
	}
}

function showMenuItem(itemId,itemName){
	var menuItem = document.getElementById(itemId);
	menuItem.className = "menuLink";
	menuItem.title = "";
	menuItem.href="javascript:showItem('" + itemName + "');";
}

function hideMenuItem(itemId){
	var menuItem = document.getElementById(itemId);
	menuItem.className = "menuLinkInactive";
	menuItem.title = "Disabled";
	menuItem.href="#";
}

function handleGetProfile(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	
	profileData = doParse(responseData);
	
	setAddDropMenu()	
	switch(rAction){
		case "port":
			doGetRequest(serviceURL+settingsFolder+"port"+(portNum-1)+"/"+"port.ini",handlePorts);	
			break;
		case "mux":			
			fillForm(document.forms["formMux"],profileData);
			setMuxFileds(profileData.muxAddDropMode!=1);	
			handleEnableSDT_change(document.forms["formMux"]);
			//handleEnable_change(document.forms["formMux"]);
			handleNoSignal_change(document.forms["formMux"].NoVideoSlideEnable);
			handleSlideSource_change(document.forms["formMux"].SlideSource);
			hidePopWin();
			break;
		case "RF":
			fillForm(document.forms["formRF"],profileData);
			//add drop setting
			//setRFFileds(profileData.muxAddDropMode!=1);
			//qamModulation settings
			qamModulation_Change(profileData["qamModulation"]);
			setUserDefineSymbolRate(document.forms["formRF"].qamBandwidth.selectedIndex==0);
			hidePopWin();
			
			break;
		
	}
}

function handleEnableSDT_change(frmObj){
	frmObj.muxOriginal_Network_ID.disabled = (frmObj.muxSDTEnable.value == 1);
}

//function handleEnablePSIP_change(frmObj){
//	frmObj.muxOriginal_Network_ID.disabled = !frmObj.muxPSIPEnable.checked;
//}
function handlePorts(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	var tmpObj = doParse(responseData);			
	portsData[portNum-1] = tmpObj;	
	//loop all ports	
	if(portNum<portCount){
		portNum++				
		doGetRequest(serviceURL+settingsFolder+"port"+(portNum-1)+"/"+"port.ini",handlePorts);
	}else{		
		portNum =1;
		getEncoderBoards();		
	}
}

function detectEncoder_clickHandler(){	
	getEncoderBoards(document.getElementById("portNumber").selectedIndex);
}

function getEncoderBoards(portNumber){
	var postData = (portNumber==null)? "":String(portNumber);
	doPostRequest(postURL+"?get_encoder_boards",postData,handleEncoderBoards);
}


function handleEncoderBoards(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	var encoders = new Object();
	encoders = doParse(responseData);
	var portNum;
	for(var param in encoders){
		portNum = Number(param.split("port")[1]);		
		portsData[portNum].encoderType = encoderTypes[Number(encoders[param])];
		if(encoders[param]=="0"){
			portsData[portNum].portActiveEnable = 0;	
		}
		else if(encoders[param]=="8") 
		{

			document.getElementById('demod_freq').innerHTML = '[47000 - 897000]';
			
		}
		else if(encoders[param]=="4") 
		{

			document.getElementById('demod_freq').innerHTML = '[54000 - 866000]';
		}
		else{
			//portsData[portNum].portActiveEnable = 1;
		}
		//duplicate ports data for view use
		portsDataDisplay[portNum] = copyObject(portsData[portNum]); 
		
		if(portNum == document.getElementById("portNumber").selectedIndex){
			//fill the port form
			setPortsFileds(profileData.muxAddDropMode!=1);	
			getPortData(portNum);	
		}
		fillPortsTable(portNum,portsData[portNum]);
		
	}
	
	hidePopWin();
}


// file upload handlers
function startUpload(){	
	showPopWin("<p>DVIS Version Upload in Progress ..<br> Please Wait.<br></p><div id='pbPH'></div>", 250, 120, null,null,"Info.",true);	
	document.forms["formUpdate"].action = uploadURL;
	var contentDocument;
	if (window.navigator.userAgent.indexOf("MSIE") > -1){
		contentDocument = document.frames["popupFrame"].document;		
	}else{
		contentDocument = document.getElementById("popupFrame").contentDocument;		
	}	
	progressBarInit(contentDocument);
	return true;
}

function completeUpload(response){
	//stop the progress bar event
	progress_bar_active = false;
	hidePopWin();
	document.location.replace("uploadDone.html")
}


function doMaintRequest(){
	showPopWin("<p>DVIS Loading Configuration ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
	doGetRequest(serviceURL+settingsFolder+"maint.ini",handleMaint);
	
	
}

function handleMaint(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	
	maintData = doParse(responseData);			
	fillForm(document.forms["formMAINT"],maintData);
	doGetRequest(serviceURL+settingsFolder+"net.ini",handleNet);
	
		
}

function handleNet(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	
	netData = doParse(responseData);
	fillForm(document.getElementById('formNET'),netData);	
	doGetStatusRequest();	
}


function askForceRemote(){
	showConfirmWin("Are You Sure You Want To <br>Force Update?", 250, 120, sendForceRemote,null,"Confirmation.");
	//showPopWin("<p>DVIS force remote update in progress ..<br> Please wait.</p>", 250, 120, null,null,"Info.");	
	//doPostRequest(postURL+"?force_remote_update","",handleForceRemote);
}

function setSchedualeElements(el){	
	var elState = el.checked;
	el.form.maintRemoteDay.disabled = !elState;
	el.form.maintRemoteHour.disabled = !elState;
	
}


function sendForceRemote(){
	showPopWin("<p>DVIS Force Remote Update In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);	
	doPostRequest(postURL+"?force_remote_update","",handleForceRemote);
}

function openChangePasswordDialog(){
	showFormWin('<form id="changPasswordFrm" name="changPasswordFrm"><label>User Name:</label><input  name="old_user" type="text" class="textBox" id="old_user" /><br><label>Password:</label><input name="old_pass" type="password" class="textBox" id="old_pass" /><br><label>New User Name:</label><input name="new_user" type="text" class="textBox" id="new_user" /><br><label>New Password:</label><input name="new_pass" type="password" class="textBox" id="new_pass" /><br><label>Confirm Password:</label><input name="conf_pass" type="password" class="textBox" id="conf_pass" /><br><label id="lblError" style="color:#990033;font-size:11px;width:180px"></label><br></form>', 270, 240, sendPaswordChange,null,"Change User/Password");
	
	
}

function sendPaswordChange(frmObj){
	var dataObj = {old_user:null,old_pass:null,new_user:null,new_pass:null};
	fillObject(dataObj,frmObj);
	if(frmObj.conf_pass.value != frmObj.new_pass.value){
		popFormSetMessage("New Password and Confirm Password Fields Must Match.");
		return;
	}
	if(dataObj.old_user==""  || dataObj.old_pass=="" || dataObj.new_user=="" || dataObj.new_pass=="" ){
		popFormSetMessage("Please Fill-in All Fields.");
		return;
	}
	if(dataObj.new_user.length<3 || dataObj.new_pass.length<3 ){
		popFormSetMessage("Field Length Must Be More Than 3 Characters.");
		return;
	}
	popFormSetMessage("");
	var postStr = objectToPostString(dataObj);	
	doPostRequest(postURL+"?change_user_pass",postStr,handle_change_user_pass);

}

function handle_change_user_pass(){
	var responseData = checkRequestStatus();
	if(responseData==null) return;
	
	showPopWin("<p>DVIS Settings Successfully Updated.<br><br>Password/User Changes Will Be Active Only After Next System Reboot.</p>", 250, 120, null,true,"Info.");
}

function handleForceRemote(){
	var responseData = checkRequestStatus();
	if(responseData==null) return;	
	showPopWin("<p>"+responseData+"</p>", 250, 120, null,true,"Info.");
}

function doGetStatusRequest(){
	unMarkFormTable("tableMAINT");
	showPopWin("<p>Getting DVIS Status Information ..<br> Please Wait.</p>", 250, 120, null,null,"Info.", true);
	doPostRequest(postURL+"?get_status","",this.handleGetStatus);
	
	
}

function handleGetStatus(){
	  	
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	
	getStatusData = doParse(responseData);			
	fillForm(document.forms["formMAINT"],getStatusData);
	//for MAC address
	fillForm(document.forms["formNET"],getStatusData);
	
	hidePopWin();
	
	setSchedualeElements(document.getElementById("maintRemoteScheduale"));
	maintDHCP_changeState(document.getElementById("netDHCPEnable"));
	
}

//select (option , drop box) event handle 
function portNumberChange(selectObj){
	unMarkTable("portsTable");
	unMarkFormTable("tableAV");
	getPortData(selectObj.value-1);
	
}

//select (option , drop box) event handle 
function videoStandard_Change(selectObj){
	var currentStandard;
	switch(selectObj.value){
		case 1:
			currentStandard = mpgVidResPAL;
			break;
		case 2:
			currentStandard = mpgVidResNTSC;
			break;
		case 3:
			currentStandard = mpgVidResAN_HD;
			break;
		default:
			currentStandard = mpgVidResPAL;
			break;
	}
	
	var mpgVidRes = document.formAV["mpgVidRes"];
	//var range_audio = document.formAV["range_audio"];
	//alert(range_audio);
	for(var i = 0;i<mpgVidRes.length;i++){
		for(var j = 0;j<currentStandard.length;j++){
			//alert(mpgVidRes.options[i].value)
			if(currentStandard[j].value== mpgVidRes.options[i].value){
				mpgVidRes.options[i].text = currentStandard[j].name;
			}
		}
				
	}
	
}

//send selected profile from when profiles select changes
function selectProfile(value){
	var selectedProfile= document.getElementById("profiles").value;
		
	showPopWin("<p>DVIS Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
	//submit by http request object
	
	doPostRequest(postURL + "?set_current_profile","profProfileInUse="+selectedProfile,handleSetProfile);
}

function handleSetProfile(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;	
	hidePopWin();
	var profileElement = document.getElementById("profiles")
	settingsFolder =  profileElement.options[profileElement.selectedIndex].text + "/";
	showItem("AV");
}

function doSetNetwork(){
	frmObj = document.forms["formNET"];
	fillObject(netData,frmObj);
	var postStr = objectToPostString(netData);		
	showPopWin("<p>DVIS Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
	//submit by http request object
	
	doPostRequest(postURL + "?set_network_values",postStr);
}


function getBoardTime(){
	//doPostRequest("getDate.php" + "?get_board_time","",handleGetBoardTime);
	doPostRequest(postURL +"?get_board_time","",handleGetBoardTime);

	
}

function sendBoardTime(frmObj){
	var dt_datetime = Cal().prs_tsmp(frmObj.time.value)
	if(dt_datetime==null)
		return;
	
	var postStr =	(dt_datetime.getDate() < 10 ? '0' : '') + dt_datetime.getDate()
		+ (dt_datetime.getMonth() < 9 ? '0' : '') + (dt_datetime.getMonth() + 1)
		+ String(dt_datetime.getFullYear()).substring(2,4)
		+ (dt_datetime.getHours() < 10 ? '0' : '') + dt_datetime.getHours()
		+ (dt_datetime.getMinutes() < 10 ? '0' : '') + (dt_datetime.getMinutes());	
	doPostRequest(postURL+"?set_board_time",postStr,handle_setBoardTime);

}

function handle_setBoardTime(){
	var responseData = checkRequestStatus();
	if(responseData==null) return;
	
	showPopWin("<p>DVIS Settings Successfully Updated.<br></p>", 250, 120, null,true,"Info.");
}


function handleGetBoardTime(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	var DD = responseData.substring(0,2);
	var MM = responseData.substring(2,4);
	var YY = "20" + responseData.substring(4,6);
	
	var HH = responseData.substring(6,8);
	var mm = responseData.substring(8,10);
	
	var dateTimeStr = DD+"-"+MM+"-"+YY+" "+HH+":"+mm;
	
	var formStr = '<form id="changPasswordFrm" onSubmit="window.top.callOwner(true);return false;" name="changPasswordFrm"><label>Board Time:</label><br><input  name="time" type="text" class="textBox" style="width:120px;"id="time" value="'+dateTimeStr+'" /><a href="javascript:top.Cal().popup();"><img src="calendar/img/cal.gif" width="16" height="16" border="0" alt="Click Here to Pick up the date" /></a><br> To change Board Time update the Value and press Send.<label id="lblError" style="color:#990033;font-size:11px;width:180px"></label><br></form>';
	showFormWin(formStr, 270, 200, sendBoardTime,null,"Board Time");
	
}

function qamMode_Change(value){
	var obj = document.forms["formRF"].qamBandwidth;
	if(value=="64"){
		obj.options[4].text = "5056";				
		obj.options[4].value = "5056";				
	}else{
		obj.options[4].text = "5360";		
		obj.options[4].value = "5360";				
	}
	obj.selectedIndex = 4;
	
}

function qamBandwidth_selectChange(obj){
	setUserDefineSymbolRate(obj.selectedIndex==0);
	if(obj.selectedIndex==0){
		document.getElementById("qamBW_userDefine").style.display = "inline";
	}else{
		document.getElementById("qamBW_userDefine").style.display = "none";	
		
	}
	
}

function setUserDefineSymbolRate(state){
	
	document.forms["formRF"].qamBandwidth_dynamic.allowEmpty = !state;
	if(state){
		document.forms["formRF"].qamBandwidth_dynamic.isValueBetween = [2000,7000];
		document.forms["formRF"].qamBandwidth_dynamic.isInteger = true;
	}else{
		document.forms["formRF"].qamBandwidth_dynamic.isValueBetween = null;
		document.forms["formRF"].qamBandwidth_dynamic.isInteger = false;
	}
}

function qamModulation_Change(value){
	
	var str;
	var frmObj = document.forms["formRF"];
	var obj = frmObj.qamInterleaving;
	if(value=="2" || value==2){
		//reset qam inteleaving text
		if(obj.value=="")
			obj.value = document.qamInterleavingLastValue;	
		if(document.qamInterleavingLastValue == "")
			obj.selectedIndex=0;
		
		document.getElementById("qamBandwidth").disabled = true;
		document.getElementById("qamInterleaving").disabled = false;
		//set qam mode settings
		str='<select name="qamMode"  id="qamMode" class="optionBox" onChange="qamMode_Change(this.value)">';
        if(frmObj.qamMode.value == "64"){
			  str += '<option value="64" selected>64</option>';
			  str += '<option value="256" >256</option>';
		}else{
			 str += '<option value="64" >64</option>';
			  str += '<option value="256" selected>256</option>';
		}
        str += '</select>';
		document.getElementById("qamModeContainer").innerHTML= str;		
		
		
		//document.qamModeLastText = frmObj.qamBandwidth.options[3].text;
		qamMode_Change(frmObj.qamMode.value);
		document.getElementById("qamBW_userDefine").style.display = "none";
		setUserDefineSymbolRate(false);
		
	}else{
		if(obj.selectedIndex>-1)
			document.qamInterleavingLastValue = obj.value;
			//document.qamInterleavingLastText = obj.options[obj.selectedIndex].text;
		
		//obj.options[obj.selectedIndex].text = "";
			
		obj.value = "";
		obj.disabled = true;
		document.getElementById("qamBandwidth").disabled = false;
		document.getElementById("qamInterleaving").disabled = true;
		str='<select name="qamMode"  id="qamMode" class="optionBox" >';
        str += '<option value="16">16</option>';
        str += '<option value="32">32</option>';
        str += '<option value="64">64</option>';
        str += '<option value="128">128</option>';
        str += '<option value="256">256</option>';
        str += '</select>';
		document.getElementById("qamModeContainer").innerHTML= str;
		//reset to the original value of qam bandwidth 6Mhz
		frmObj.qamBandwidth.options[4].text = "5217";
		frmObj.qamBandwidth.options[4].value = "5217";
		//check if qamBandwidth is user define
		
		if(frmObj.qamBandwidth.selectedIndex<=0){
			frmObj.qamBandwidth_dynamic.value = profileData["qamBandwidth"];
			frmObj.qamBandwidth.selectedIndex = 0;
			document.getElementById("qamBW_userDefine").style.display = "inline";
		}
		document.getElementById("qamMode").value = eval(profileData["qamMode"]);
	}
	
}

function beforeSubmit(frmObj,type){
	
	if(!validateForm(frmObj,type)) {
	
			return false;
	}
	/*
	for(var i=0;i<frmObj.elements.length;i++){		
				if(frmObj.elements[i].type=="button"){
					alert(frmObj.elements[i].value)	
					
				}
			}
			*/
	switch(type){
		case "IP_OUT":
			if(!validateIP_Out()){
				
				showPopWin("<p>Please Correct The Values That Are Marked In Red.</p>", 250, 120, null,true,"Warning");
				return false;
			}
			//itayb 12.12


		var frmIp = document.forms["formIP_OUT"];

			//var frm = document.forms["formMux"];
			if(((profileData.muxOutput == 1) || (profileData.muxOutput == 3)) && (frmIp.muxSPTSEnable.checked))
			{
				showPopWin("<p>for SPTS mode Please change output selection to Ethernet only</p>", 250, 120, null,true,"Warning");
				return false;
			}
//(profileData.muxAddDropMode == 1) 
			if( (profileData.muxAddDropMode == 1) && (frmIp.muxSPTSEnable.checked) )
			{
				showPopWin("<p>SPTS is disabled in 'Add and Drop' mode</p>", 250, 120, null,true,"Warning");
				return false;
			}
			//itayb 12.12
			rAction = "IP_OUT";
			fillObject(gbitPortData,frmObj);
			var postStr = objectToPostString(gbitPortData);
			
			postStr = "[general]\n" + postStr;
			postStr = postStr.replace("udpHostIpAddr","[udp]\nudpHostIpAddr");
			postStr = postStr.replace("rtpEnableFec","[rtp_fec]\nrtpEnableFec");
			postStr = postStr.replace("rtpEncapType","[rtp_encap]\nrtpEncapType");
			postStr = postStr.replace("vlansEnable","[vlan]\nvlansEnable");
			postStr = postStr.replace("muxSPTSEnable","[tsout]\nmuxSPTSEnable");
			
			var SPTSdata = getSPTSPostData();
			postStr += SPTSdata;
			
			showPopWin("<p>DVIS Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
			//submit by http request object
			doPostRequest(postURL + "?Gbit",postStr,handleGbitSubmit);
			break;
		case "MAINT":
			rAction = "maint";
			var setStatusData = new Object();
			setStatusData.maintFanTemperature=frmObj.maintFanTemperature.value;
			setStatusData.maintPanicTemperature=frmObj.maintPanicTemperature.value;
						
			setStatusData.maintRemoteServer= "\"" + (frmObj.maintRemoteServer.value) + "\"";			
			setStatusData.maintRemotePort= frmObj.maintRemotePort.value;			
			setStatusData.maintSnmpServer= "\""+frmObj.maintSnmpServer.value+"\"";			
			setStatusData.maintSnmpPort= frmObj.maintSnmpPort.value;			
			setStatusData.maintRemoteScheduale= (frmObj.maintRemoteScheduale.checked)? 1:0;			
			setStatusData.maintRemoteDay= frmObj.maintRemoteDay.value;			
			setStatusData.maintRemoteHour= "\""+frmObj.maintRemoteHour.value+"\"";						
								
			var postStr = objectToPostString(setStatusData);		
			
			showPopWin("<p>DVIS Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);						
			//submit by http request object
			doPostRequest(postURL+"?set_maint_values",postStr);		
			break;
		case "NET":			
			rAction = "net";
			//show prompt window
			showConfirmWin("<p>Are You Sure You Want To Change The Network Parameters?</p>", 250, 120, doSetNetwork,null,"Please Confirm.")
			break;
		
		case "AV":
			rAction = "port";
			var portNumber= document.getElementById("portNumber").selectedIndex;
			
			var postStr = objectToPostString(portsData[portNumber]);
			
			showPopWin("<p>DVIS Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
			//submit by http request object
			doPostRequest(postURL + "?port="+portNumber,postStr);			
			break;
		case "Mux":

		var frmIp = document.forms["formIP_OUT"];

			var frm = document.forms["formMux"];
			if(((frm.muxOutput.value == "1") || (frm.muxOutput.value == "3")) && (frmIp.muxSPTSEnable.checked))
			{
				showPopWin("<p>RF can't be active in SPTS mode!!</p>", 250, 120, null,true,"Warning");
				return false;
			}

			if((frm.muxAddDropMode.checked) && (frmIp.muxSPTSEnable.checked))
			{
				showPopWin("<p>Add and Drop can't be active in SPTS mode!!</p>", 250, 120, null,true,"Warning");
				return false;
			}
	
			rAction = "mux";
			fillObject(profileData,frmObj);
			var postStr = objectToPostString(profileData);
			
			showPopWin("<p>DVIS Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
			doPostRequest(postURL+"?RF",postStr);
			break;
		case "RF":
			rAction = "profile";
			fillObject(profileData,frmObj);
			if(profileData.qamBandwidth == ""){
				profileData.qamBandwidth = frmObj.qamBandwidth_dynamic.value; 	
			}
			var postStr = objectToPostString(profileData);	
		
			showPopWin("<p>DVIS Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
			doPostRequest(postURL+"?RF",postStr);
			document.qamInterleavingLastValue = frmObj.qamInterleaving.value;
			break;
	}
	return false;
}


function revertAllPorts(){
	/*
	for(var i=0;i<portCount;i++){
		portsDataDisplay[i] = copyObject(portsData[i]);
		fillPortsTable(i,portsData[i]);		
	}
	fillForm(document.getElementById('formAV'),portsData[document.getElementById("portNumber").selectedIndex]);
	*/
	unMarkFormTable("tableAV");
	unMarkTable("portsTable");
	doGetProfile();
}

function submitAllPorts(){
	rAction = "portAll";
	var postStr = "";
	var hasEncoderErrors = false;
	var bad_range_vweb = false;
	var bad_range_hd = false;
	for(var i=0;i<portCount;i++){
		if(!validatePortEncoderData(portsDataDisplay[i],i)){
			hasEncoderErrors = true;			
		}
		postStr += "\n[port " + (i+1) + "]\n";		
		postStr += objectToPostString(portsDataDisplay[i]);	
	}

	for(var i=0;i<portCount;i++)
	{

		switch(portsDataDisplay[i].encoderType)
		{	
			/*case "VWEB_NA":		
				if(portsDataDisplay[i].mpgVidRate > 4000)
				{	
									
					bad_range_vweb = true;					
					
				}											
				break;
			case "VWEB_NA_1":		
				if(portsDataDisplay[i].mpgVidRate > 4000)
				{					
					bad_range_vweb = true;					
					
				}											
				break;
			case "VWEB_EU":							
				if(portsDataDisplay[i].mpgVidRate > 4000)
				{					
					bad_range_vweb = true;					
					
				}											
				break;
			case "VWEB_EU_1":							
				if(portsDataDisplay[i].mpgVidRate > 4000)
				{					
					bad_range_vweb = true;					
					
				}											
				break;*/
			case "AN_HD":
				if(portsDataDisplay[i].mpgVidRate < 1000)	
				{
					bad_range_hd = true;
				}
				break;
		}
		
	}
			

	if(hasEncoderErrors){
		if(bad_range_hd)
		//if(bad_range_vweb && bad_range_hd)
			showPopWin("<p>Please Correct The Values That Are Marked In Red. <br/> HD video bit rate should be greater than 6000kbps!!</p>", 250, 120, null,true,"Warning");
		//else if(bad_range_hd)
		//showPopWin("<p>Please Correct The Values That Are Marked In Red. <br/> HD video bit rate should be greater than 6000kbps</p>", 250, 120, null,true,"Warning");
		//else if(bad_range_vweb)
		//showPopWin("<p>Please Correct The Values That Are Marked In Red. <br/> VWEB video bit rate should be less than 4000kbps</p>", 250, 120, null,true,"Warning");
		else
		showPopWin("<p>Please Correct The Values That Are Marked In Red.</p>", 250, 120, null,true,"Warning");
		
		return;
	}
	showPopWin("<p>DVIS Configuration In Progress ..<br> Please Wait.</p>", 250, 120, null,null,"Info.",true);
	//submit by http request object
	doPostRequest(postURL + "?port=ALL",postStr);		
}

//mark cells in ports table
function markCell(col,paramName){
	var rows = document.getElementById("portsTable").rows;
	var cell;
	for(var x=1;x<rows.length;x++){						
		if(rows[x].cells[0].getAttribute("ref")== paramName){
			cell = rows[x].cells[col];
			cell.style.color = "#FF0000";						
		}
	}
}

//check the display for encoder errors
function validatePortEncoderData(dataObj,index){
		
	var retVal = true;
	switch(dataObj.encoderType){			
			case "NXP":			
				if(dataObj.vbiMode != vbiModeTypes[0].value){
					markCell(index,"vbiMode");										
					return false;
				}
				if(dataObj.mpgAudRate != mpgAudRateTypes[1].value && dataObj.mpgAudRate != mpgAudRateTypes[2].value){
					markCell(index,"mpgAudRate");
					retVal = false;
				}
				if(dataObj.mpgAudCodec != mpgAudCodecTypes[0].value && dataObj.mpgAudCodec != mpgAudCodecTypes[1].value){
					markCell(index,"mpgAudCodec");					
					retVal = false;
				}
				if(dataObj.inVideoStandard == 1){
					if(dataObj.mpgVidRes != mpgVidResPAL[0].value && dataObj.mpgVidRes != mpgVidResPAL[4].value && dataObj.mpgVidRes != mpgVidResPAL[5].value){
						markCell(index,"mpgVidRes");						
						retVal = false;
					}
				}
				if(dataObj.inVideoStandard == 2){
					if(dataObj.mpgVidRes != mpgVidResNTSC[0].value && dataObj.mpgVidRes != mpgVidResNTSC[4].value && dataObj.mpgVidRes != mpgVidResNTSC[5].value){
						markCell(index,"mpgVidRes");						
						retVal = false;
					}
				}				
				break;				
			case "VWEB_NA":		
				if(dataObj.vbiMode != vbiModeTypes[0].value && dataObj.vbiMode != vbiModeTypes[5].value){
					markCell(index,"vbiMode");										
					retVal = false;
				}
				if(dataObj.mpgAudCodec != mpgAudCodecTypes[1].value){					
					markCell(index,"mpgAudCodec");					
					retVal = false;
				}	
				if(dataObj.mpgVidRate > 8000)	
				{
					markCell(index,"mpgVidRate");	
					retVal = false;
				}										
				break;
			case "VWEB_NA_1":		
				if(dataObj.vbiMode != vbiModeTypes[0].value && dataObj.vbiMode != vbiModeTypes[5].value){
					markCell(index,"vbiMode");										
					retVal = false;
				}
				if(dataObj.mpgAudCodec != mpgAudCodecTypes[1].value){					
					markCell(index,"mpgAudCodec");					
					retVal = false;
				}	
				if(dataObj.mpgVidRate > 8000)	
				{
					markCell(index,"mpgVidRate");	
					retVal = false;
				}											
				break;
			case "VWEB_EU":							
				
				if(dataObj.mpgAudCodec != mpgAudCodecTypes[0].value){
					markCell(index,"mpgAudCodec");					
					retVal = false;
				}	
				if(dataObj.mpgVidRate > 8000)	
				{
					markCell(index,"mpgVidRate");	
					retVal = false;
				}							
				break;	
			case "VWEB_EU_1":							
				
				if(dataObj.mpgAudCodec != mpgAudCodecTypes[0].value){
					markCell(index,"mpgAudCodec");					
					retVal = false;
				}	
				if(dataObj.mpgVidRate > 8000)	
				{
					markCell(index,"mpgVidRate");	
					retVal = false;
				}							
				break;	
			case "AN_HD":
				if(dataObj.mpgVidRate < 1000)	
				{
					markCell(index,"mpgVidRate");	
					retVal = false;
				}
				break;
		}
		return retVal;
}


//var menuItemsLength=3;
function showItem(menuItem){
	window.clearInterval(get_status_interval);
	document.getElementById("itemAV").style.display = "none";
	document.getElementById("itemIP_OUT").style.display = "none";
	document.getElementById("itemMux").style.display = "none";
	document.getElementById("itemUpdate").style.display = "none";
	document.getElementById("itemRF").style.display = "none";
	document.getElementById("itemMAINT").style.display = "none";
	document.getElementById("logView").style.display = "none";
	document.getElementById("move2tableContainer").style.display = "none";
	document.getElementById("addDropPanel").style.display = "none";
	document.getElementById("addDropTree").style.display = "none";
	document.getElementById("SPTS_panel").style.display = "none";
	switch(menuItem){
		case "Update":
			document.getElementById("portsView").style.display = "none";
			document.getElementById("item"+menuItem).style.display = "block";
			break;
		case "IP_OUT":
			unMarkFormTable("table"+menuItem);
			document.getElementById("portsView").style.display = "none";
			document.getElementById("item"+menuItem).style.display = "block";
			document.getElementById("SPTS_panel").style.display = "block";
			getGbitPortData();
			break;
		case "LOG": 
			document.getElementById("portsView").style.visibility = "hidden";
			document.getElementById("logView").style.display = "block";
			return;
		case "AV":
			unMarkFormTable("table"+menuItem);
			unMarkTable("portsTable");	
			document.getElementById("portsView").style.display = "block";
			document.getElementById("portsView").style.visibility = "visible";
			document.getElementById("itemAV").style.display = "block";
			document.getElementById("move2tableContainer").style.display = "block";
			rAction="port";
			document.getElementById("portNumber").selectedIndex=0;
			portNum=1;
			doGetProfile();
			break;
		case "AddDrop":
			document.getElementById("portsView").style.display = "none";
			document.getElementById("addDropPanel").style.display = "block";
			document.getElementById("addDropTree").style.display = "block";
			
			getTS();
			break;
		case "MAINT":
			unMarkFormTable("table"+menuItem);
			unMarkFormTable("tableNET");
			//document.getElementById("portsView").style.visibility = "hidden";
			document.getElementById("portsView").style.display = "none";

			document.getElementById("item"+menuItem).style.display = "block";
			doMaintRequest();
			break;
		case "Mux":
		
			unMarkFormTable("table"+menuItem);
			document.getElementById("portsView").style.display = "none"
			//document.getElementById("portsView").style.visibility = "hidden";
			document.getElementById("item"+menuItem).style.display = "block";			
			rAction="mux";
			doGetProfile();
			//fillForm(document.getElementById('form'+menuItem),profileData);
			break;
		case "RF":
			unMarkFormTable("table"+menuItem);
			document.getElementById("portsView").style.display = "none"		
			//document.getElementById("portsView").style.visibility = "hidden";
			document.getElementById("item"+menuItem).style.display = "block";
			rAction="RF";
			doGetProfile();
			break;
	}
		
}

function doReload(){
	
	doGetProfile(false);
}

function handlePostResponse(){
	//showPopWin("<p>DVIS settings successfully updated.</p>", 250, 120, null,null,"Info.");
	switch(rAction){
		case "maint":
			showPopWin("<p>DVIS Settings Successfully Updated.</p>", 250, 120, null,true,"Info.");
			var frmObj = document.forms["formMAINT"];
			fillObject(maintData,frmObj);
			
			break;
		case "net":
			showPopWin("<p>DVIS Settings Successfully Updated.</p>", 250, 120, null,true,"Info.");
			fillObject(netData,formNET);	
			break;
		case "mux":
			showPopWin("<p>DVIS Settings Successfully Updated.</p>", 250, 120, doReload,true,"Info.");
			
			break;
		
		case "port":
			showPopWin("<p>DVIS Settings Successfully Updated.</p>", 250, 120, null,true,"Info.");
			var portNumber= document.getElementById("portNumber").selectedIndex;
			fillObject(portsData[portNumber],document.getElementById("formAV"));
			portsDataDisplay[portNumber] = copyObject(portsData[portNumber]);
			fillPortsTable(portNumber,portsData[portNumber])
			break;
		case "portAll":
			showPopWin("<p>DVIS Settings Successfully Updated.</p>", 250, 120, null,true,"Info.");
			for(var i=0;i<portCount;i++){
				portsData[i] = copyObject(portsDataDisplay[i]);	
			}
			break;
		default:
			showPopWin("<p>DVIS Settings Successfully Updated.</p>", 250, 120, null,true,"Info.");
			break;
	}
}

//parse string in ini file format to object 
function doParse(str){	
	var tmpObj=new Object();
	var tmpArr = str.split("\n");
	for(var i=0;i<tmpArr.length;i++){
		if(tmpArr[i].charAt(0)=="#" || tmpArr[i].charAt(0)=="[" || tmpArr[i].length<3) continue;
		tmpObj[tmpArr[i].split("=")[0]] = tmpArr[i].split("=")[1]; 
	}	
	return tmpObj
}




//parse string in ini file format to object 
function iniToArrayObject(str,splitter){	
	var tmpObj;
	var tempObjArr=new Array();
	var objCount;
	var tmpObj=new Object();
	var tmpArr = str.split("\n");
	for(var i=0;i<tmpArr.length;i++){
		if(tmpArr[i].charAt(0)=="#" || tmpArr[i].length<3) 
			continue;
		if(tmpArr[i].charAt(0) == splitter){
			if(objCount==null)
				objCount=0;
			else{
				//push the object to the array
				tempObjArr.push(tmpObj);
				objCount++;
				tmpObj = new Object();
			}
			
			continue;
			
		}
		tmpObj[tmpArr[i].split("=")[0]] = tmpArr[i].split("=")[1]; 
	}
	//push the object to the array
	if(objCount!=null)
		tempObjArr.push(tmpObj);
	return tempObjArr
}

//fill form data from data object array and by type config 
function getPortData(portNumber){
	
	var i;
	var try1;
	rAction = "port";
	var frmObj = document.forms["formAV"];
	//var myTextField = document.getElementById('try2')
	var frm_mux_psip = document.forms["formMux"];
	if(portsDataDisplay[portNumber] != null){
		
		for(var i=0;i<frmObj.elements.length;i++){			
			frmObj[i].disabled = false;
		}

		//portsDataDisplay[portNumber].VideoInput = "1";
		//portsData[portNumber].VideoInput = "1";
		//TODO : this should be constant in config stage
		frmObj.inAudioSampleRate.disabled=true;	
		frmObj.VBR.disabled=true;
		frmObj.VideoInput.disabled = true;	
		frmObj.offset_x.disabled = true;
		frmObj.offset_y.disabled = true;
		frmObj.major_channel.disabled = false;
		frmObj.minor_channel.disabled = false;
		frmObj.source_id.disabled = false;
		//document.getElementById('try2').innerHTML = 'blabla';

		document.getElementById('try2').innerHTML = '[1000 - 8000]';
		var comp_vga = 0
		frmObj.enc_type_hidden.value = "[0 - 255]";

		//if(portsData[3].encoderType == 8) {
		//
		//		document.getElementById('demod_freq').innerHTML = '[1000 - 6000]';
		//}

		switch(portsData[portNumber].encoderType){	
			case "NXP":
if(profileData.muxSDTEnable != 3)//psip
{
	//frmObj.progID.disabled = true;
	frmObj.major_channel.disabled = true;
	frmObj.minor_channel.disabled = true;
	frmObj.source_id.disabled = true;

}
				comp_vga = 0;
				removeOptions(frmObj.vbiMode);
				insertOption(frmObj.vbiMode,vbiModeTypes[0]);
				
				removeOptions(frmObj.mpgAudRate);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[1]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[2]);
				
				removeOptions(frmObj.mpgAudCodec);
				insertOption(frmObj.mpgAudCodec,mpgAudCodecTypes[0]);
				insertOption(frmObj.mpgAudCodec,mpgAudCodecTypes[1]);
				
				removeOptions(frmObj.mpgVidRes);				
				if(portsDataDisplay[portNumber].inVideoStandard == 1){
					//PAL
					insertOption(frmObj.mpgVidRes,mpgVidResPAL[0]);
					insertOption(frmObj.mpgVidRes,mpgVidResPAL[4]);
					insertOption(frmObj.mpgVidRes,mpgVidResPAL[5]);	
					
				}else if(portsDataDisplay[portNumber].inVideoStandard == 2){
					//NTSC
					insertOption(frmObj.mpgVidRes,mpgVidResNTSC[0]);
					insertOption(frmObj.mpgVidRes,mpgVidResNTSC[4]);
					insertOption(frmObj.mpgVidRes,mpgVidResNTSC[5]);
				}else if(portsDataDisplay[portNumber].inVideoStandard == 3){
					//AN_HD
					for(var x=0;x<mpgVidResAN_HD.length;x++){
						insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[x]);
					}
				}
				portsDataDisplay[portNumber].VidCodec = "1";
				portsData[portNumber].VidCodec = "1";
				frmObj.VidCodec.disabled = true;
				portsDataDisplay[portNumber].VBR = "0";
				portsData[portNumber].VBR = "0";
				frmObj.VBR.disabled = true;
				portsDataDisplay[portNumber].AudioInput = "2";
				portsData[portNumber].AudioInput = "2";
				frmObj.AudioInput.disabled = true;
				frmObj.AVSync.disabled = true;
				
				break;
			case "VWEB_NA":
if(profileData.muxSDTEnable != 3)//psip
{
	//frmObj.progID.disabled = true;
	frmObj.major_channel.disabled = true;
	frmObj.minor_channel.disabled = true;
	frmObj.source_id.disabled = true;

}
				comp_vga = 0;
				frmObj.inVideoStandard.value = 2;
				frmObj.enc_type_hidden.value = "[0 - 255]";
				portsDataDisplay[portNumber].inVideoStandard = 2;
				portsData[portNumber].inVideoStandard = 2;
				frmObj.inVideoStandard.disabled = true;
				
				removeOptions(frmObj.vbiMode);
				insertOption(frmObj.vbiMode,vbiModeTypes[0]);
				insertOption(frmObj.vbiMode,vbiModeTypes[5]);
				
				removeOptions(frmObj.mpgAudRate);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[0]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[1]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[2]);
				
				removeOptions(frmObj.mpgAudCodec);				
				insertOption(frmObj.mpgAudCodec,mpgAudCodecTypes[1]);
				
				removeOptions(frmObj.mpgVidRes);
				for(i = 0;i<mpgVidResPAL.length;i++){
					if(portsDataDisplay[portNumber].inVideoStandard == 1){
						//PAL
						insertOption(frmObj.mpgVidRes,mpgVidResPAL[i]);
					}else if(portsDataDisplay[portNumber].inVideoStandard == 2){
						//NTSC
						insertOption(frmObj.mpgVidRes,mpgVidResNTSC[i]);
					}
				}
				portsDataDisplay[portNumber].VidCodec = "1";
				portsData[portNumber].VidCodec = "1";
				frmObj.VidCodec.disabled = true;
				portsDataDisplay[portNumber].VBR = "0";
				portsData[portNumber].VBR = "0";
				frmObj.VBR.disabled = true;
				portsDataDisplay[portNumber].AudioInput = "2";
				portsData[portNumber].AudioInput = "2";
				frmObj.AudioInput.disabled = true;
				portsDataDisplay[portNumber].VideoInput = "1";
				portsData[portNumber].VideoInput = "1";
				frmObj.AVSync.disabled = true;
				//portsDataDisplay[portNumber].mpgVidRes = "544";
				//portsData[portNumber].mpgVidRes = "544";
				break;
			case "VWEB_NA_1":
if(profileData.muxSDTEnable != 3)//psip
{
	//frmObj.progID.disabled = true;
	frmObj.major_channel.disabled = true;
	frmObj.minor_channel.disabled = true;
	frmObj.source_id.disabled = true;

}
				comp_vga = 0;
				frmObj.inVideoStandard.value = 2;
				frmObj.enc_type_hidden.value = "[0 - 255]";
				//alert(frmObj.enc_type_hidden.value);
				portsDataDisplay[portNumber].inVideoStandard = 2;
				portsData[portNumber].inVideoStandard = 2;
				frmObj.inVideoStandard.disabled = true;
				
				removeOptions(frmObj.vbiMode);
				insertOption(frmObj.vbiMode,vbiModeTypes[0]);
				insertOption(frmObj.vbiMode,vbiModeTypes[5]);
				
				removeOptions(frmObj.mpgAudRate);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[0]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[1]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[2]);
				
				removeOptions(frmObj.mpgAudCodec);				
				insertOption(frmObj.mpgAudCodec,mpgAudCodecTypes[1]);
				
				removeOptions(frmObj.mpgVidRes);
				for(i = 0;i<mpgVidResPAL.length;i++){
					if(portsDataDisplay[portNumber].inVideoStandard == 1){
						//PAL
						insertOption(frmObj.mpgVidRes,mpgVidResPAL[i]);
					}else if(portsDataDisplay[portNumber].inVideoStandard == 2){
						//NTSC
						insertOption(frmObj.mpgVidRes,mpgVidResNTSC[i]);
					}
				}
				portsDataDisplay[portNumber].VidCodec = "1";
				portsData[portNumber].VidCodec = "1";
				frmObj.VidCodec.disabled = true;
				portsDataDisplay[portNumber].VBR = "0";
				portsData[portNumber].VBR = "0";
				frmObj.VBR.disabled = true;
				portsDataDisplay[portNumber].AudioInput = "2";
				portsData[portNumber].AudioInput = "2";
				frmObj.AudioInput.disabled = true;
				portsDataDisplay[portNumber].VideoInput = "4";
				portsData[portNumber].VideoInput = "4";
				frmObj.VideoInput.value = 4;
				frmObj.AVSync.disabled = true;
				//portsDataDisplay[portNumber].mpgVidRes = "544";
				//portsData[portNumber].mpgVidRes = "544";
				break;
			case "VWEB_EU":
if(profileData.muxSDTEnable != 3)//psip
{
	//frmObj.progID.disabled = true;
	frmObj.major_channel.disabled = true;
	frmObj.minor_channel.disabled = true;
	frmObj.source_id.disabled = true;

}
				comp_vga = 0;
				frmObj.inVideoStandard.value = 1;
				frmObj.enc_type_hidden.value = "[0 - 255]";
				portsDataDisplay[portNumber].inVideoStandard = 1;
				portsData[portNumber].inVideoStandard = 1;
				frmObj.inVideoStandard.disabled = true;
				
				removeOptions(frmObj.vbiMode);
				for( i = 0;i<5;i++){
					insertOption(frmObj.vbiMode,vbiModeTypes[i]);
				}				
				
				removeOptions(frmObj.mpgAudRate);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[0]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[1]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[2]);
				
				removeOptions(frmObj.mpgAudCodec);				
				insertOption(frmObj.mpgAudCodec,mpgAudCodecTypes[0]);
				
				removeOptions(frmObj.mpgVidRes);
				for( i = 0;i<mpgVidResPAL.length;i++){
					if(portsDataDisplay[portNumber].inVideoStandard == 1){
						//PAL
						insertOption(frmObj.mpgVidRes,mpgVidResPAL[i]);
					}else if(portsDataDisplay[portNumber].inVideoStandard == 2){
						//NTSC
						insertOption(frmObj.mpgVidRes,mpgVidResNTSC[i]);
					}
				}
				portsDataDisplay[portNumber].VidCodec = "1";
				portsData[portNumber].VidCodec = "1";
				frmObj.VidCodec.disabled = true;
				portsDataDisplay[portNumber].VBR = "0";
				portsData[portNumber].VBR = "0";
				frmObj.VBR.disabled = true;
				portsDataDisplay[portNumber].AudioInput = "2";
				portsData[portNumber].AudioInput = "2";
				frmObj.AudioInput.disabled = true;
				portsDataDisplay[portNumber].VideoInput = "1";
				portsData[portNumber].VideoInput = "1";
				frmObj.AVSync.disabled = true;
				//portsDataDisplay[portNumber].mpgVidRes = "544";
				//portsData[portNumber].mpgVidRes = "544";
				break;




			case "AN_HD":


				document.getElementById('try2').innerHTML = '[1000 - 25000]';
if(profileData.muxSDTEnable != 3)//psip
{
	//frmObj.progID.disabled = true;
	frmObj.major_channel.disabled = true;
	frmObj.minor_channel.disabled = true;
	frmObj.source_id.disabled = true;

}
				comp_vga = 1;
				frmObj.inVideoStandard.value = 3;
				portsDataDisplay[portNumber].inVideoStandard = 3;
				portsData[portNumber].inVideoStandard = 3;
				frmObj.enc_type_hidden.value = "[-23 - +22][db]";
				//alert(frmObj.enc_type_hidden.value);
				if((portsData[portNumber].inAudioVolume > 22) || (portsData[portNumber].inAudioVolume < -23))
				{
					frmObj.inAudioVolume.value = 0;
					portsDataDisplay[portNumber].inAudioVolume = 0;
					portsData[portNumber].inAudioVolume = 0;
				}
				//frmObj.inAudioVolume.value = 0;
				//portsDataDisplay[portNumber].inVideoStandard = 3;
				//portsData[portNumber].inVideoStandard = 3;
				frmObj.inVideoStandard.disabled = true;
				frmObj.inVideoSaturation.disabled = true;
				frmObj.AudioInput.onchange = handleAudioInput_change;


				//portsDataDisplay[portNumber].mpgVidRes = 4;
				//portsData[portNumber].mpgVidRes = 4;
				//CBR VBR
				frmObj.VidCodec.onchange = handleVidCodec_change;
				//CBR VBR

				//if(frmObj.VBR.value== "1")
				//{
				//	portsDataDisplay[portNumber].VBR = "1";
				//	portsData[portNumber].VBR = "1";
				//}
				//else
				//{
				//	portsDataDisplay[portNumber].VBR = "0";
				//	portsData[portNumber].VBR = "0";				
//
				//}


				//portsDataDisplay[portNumber].VideoInput = 1;
				//portsData[portNumber].VideoInput = 1;
				frmObj.VideoInput.disabled = false;
				
				//removeOptions(frmObj.vbiMode);
				//for( i = 0;i<5;i++){
				//	insertOption(frmObj.vbiMode,vbiModeTypes[0]);
				//}				
				
				removeOptions(frmObj.mpgAudRate);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[0]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[1]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[2]);
				
				removeOptions(frmObj.mpgAudCodec);				
				insertOption(frmObj.mpgAudCodec,mpgAudCodecTypes[1]);
						

				removeOptions(frmObj.mpgVidRes);
				//for( i = 0;i<mpgVidResAN_HD.length;i++){
				//	insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[i]);					
				//}
				frmObj.VideoInput.onchange = handleVideoInput_change;

				//handleAudioInput_change();
				handleVideoInput_change();
				try1 = handleVidCodec_change();

        removeOptions(frmObj.vbiMode);
				insertOption(frmObj.vbiMode,vbiModeTypes[0]);
				insertOption(frmObj.vbiMode,vbiModeTypes[5]);
					
			portsDataDisplay[portNumber].mpgAudCodec = 2;
			portsData[portNumber].mpgAudCodec =2;			
				//if(frmObj.VideoInput.value == 1) 
				//{
				//	insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[0]);
				//}
				//else
				//{
				//	insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[1]);
				//}
				break;
			case "VWEB_EU_1":
if(profileData.muxSDTEnable != 3)//psip
{
	//frmObj.progID.disabled = true;
	frmObj.major_channel.disabled = true;
	frmObj.minor_channel.disabled = true;
	frmObj.source_id.disabled = true;

}
				comp_vga = 0;
				frmObj.inVideoStandard.value = 1;
				frmObj.enc_type_hidden.value = "[0 - 255]";
				portsDataDisplay[portNumber].inVideoStandard = 1;
				portsData[portNumber].inVideoStandard = 1;
				frmObj.inVideoStandard.disabled = true;
				
				removeOptions(frmObj.vbiMode);
				for( i = 0;i<5;i++){
					insertOption(frmObj.vbiMode,vbiModeTypes[i]);
				}				
				
				removeOptions(frmObj.mpgAudRate);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[0]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[1]);
				insertOption(frmObj.mpgAudRate,mpgAudRateTypes[2]);
				
				removeOptions(frmObj.mpgAudCodec);				
				insertOption(frmObj.mpgAudCodec,mpgAudCodecTypes[0]);
				
				removeOptions(frmObj.mpgVidRes);
				for( i = 0;i<mpgVidResPAL.length;i++){
					if(portsDataDisplay[portNumber].inVideoStandard == 1){
						//PAL
						insertOption(frmObj.mpgVidRes,mpgVidResPAL[i]);
					}else if(portsDataDisplay[portNumber].inVideoStandard == 2){
						//NTSC
						insertOption(frmObj.mpgVidRes,mpgVidResNTSC[i]);
					}
				}
				portsDataDisplay[portNumber].VidCodec = "1";
				portsData[portNumber].VidCodec = "1";
				frmObj.VidCodec.disabled = true;
				portsDataDisplay[portNumber].VBR = "0";
				portsData[portNumber].VBR = "0";
				frmObj.VBR.disabled = true;
				portsDataDisplay[portNumber].AudioInput = "2";
				portsData[portNumber].AudioInput = "2";
				frmObj.AudioInput.disabled = true;
				frmObj.AVSync.disabled = true;
				break;
			default:
				for(var i=0;i<frmObj.elements.length;i++){			
					frmObj[i].disabled = true;
				}
				break;
			
		}
		//disable form port activate if encoder type = none		
		if(portsData[portNumber].encoderType == encoderTypes[0]){
			frmObj.portActiveEnable.disabled = true;
			frmObj.detectEncoderBtn.className = "buttonBox";
			frmObj.detectEncoderBtn.disabled = false;			
		}else{
			frmObj.portActiveEnable.disabled = (profileData.muxAddDropMode==1);
			frmObj.detectEncoderBtn.className = "buttonBoxDisabled";
			frmObj.detectEncoderBtn.disabled = true;
			
		}
		fillForm(frmObj,portsDataDisplay[portNumber]);
		handleAudioInput_change();
		if(comp_vga)
		{
			handleVideoInput_change();
			try1 = handleVidCodec_change();

				removeOptions(frmObj.vbiMode);
				insertOption(frmObj.vbiMode,vbiModeTypes[0]);
				insertOption(frmObj.vbiMode,vbiModeTypes[5]);
				portsDataDisplay[portNumber].vbiMode = portsData[portNumber].vbiMode;
				frmObj.vbiMode.value = portsData[portNumber].vbiMode;

			//removeOptions(frmObj.vbiMode);
		//if(portsDataDisplay[portNumber].VideoInput == portsData[portNumber].VideoInput)
			portsDataDisplay[portNumber].mpgVidRes = portsData[portNumber].mpgVidRes;
			//portsData[portNumber].mpgVidRes = 3;
			frmObj.mpgVidRes.value = portsData[portNumber].mpgVidRes;

			portsDataDisplay[portNumber].mpgAudCodec = 2;
			portsData[portNumber].mpgAudCodec =2;
		}
		//handleVidCodec_change();
		markPortCol(portNumber);
	}

	/*else{
		doGetRequest(serviceURL+settingsFolder+"port"+portNumber+"/"+"port.ini");
	}*/
	
		
}

function insertOption(selectObj,data){
	var y=document.createElement('option');
 	y.text=data.name;  	
 	y.value=data.value;  	
  	try{
   		selectObj.add(y,null); // standards compliant
    }catch(ex){
    	selectObj.add(y); // IE only
    }
}

function removeOptions(obj){
	var count = obj.length-1;
	for(var i=count; i>=0 ; i--){
		obj.remove(i);	
	}
}

function handleAudioInput_change(){
	var frmObj = document.forms["formAV"];
	if(frmObj.AudioInput.value == "1"){
		frmObj.inAudioVolume.disabled = true;
		frmObj.mpgAudCodec.disabled = true;
		frmObj.mpgAudRate.disabled = true;
	}else{
		frmObj.inAudioVolume.disabled = false;
		frmObj.mpgAudCodec.disabled = false;
		frmObj.mpgAudRate.disabled = false;
	}
}

function handleVideoInput_change(){
	var frmObj = document.forms["formAV"];
		
	removeOptions(frmObj.mpgVidRes);

	if(frmObj.VideoInput.value == "1") 
	{       //commnenet
		//insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[0]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[1]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[2]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[4]); //1080i
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[5]); //1080i
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[15]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[16]);
		frmObj.offset_y.disabled = true;
		frmObj.offset_x.disabled = true;
		//insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[9]);
		//insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[10]);
		//insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[11]);
	}
	else if(frmObj.VideoInput.value == "4") 
	{       //comsit
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[17]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[18]);

	}
	else
	{       //VGA res
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[22]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[9]);
		//insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[10]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[11]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[12]);
		//insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[13]);
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[14]);
		//new res doron
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[19]);//vga 1336
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[20]);//vga 1400
		insertOption(frmObj.mpgVidRes,mpgVidResAN_HD[21]);//vga 1920
		frmObj.offset_y.disabled = false;
		frmObj.offset_x.disabled = false;

	}
}


//VBR CBR
function handleVidCodec_change(){
	var frmObj = document.forms["formAV"];
	if(frmObj.VidCodec.value == 1){
	
		frmObj.VBR.checked = true;
		frmObj.vbiMode.disabled = false;
		return 1;
	}else{
		frmObj.VBR.checked = false;
		frmObj.vbiMode.disabled = false;
		return 0;
		//frmObj.VBR.value = 0;
	}
}
//VBR CBR


//fill form elements from data object
function fillForm(frmObject,dataObject){
	for(var obj in dataObject){
		
		try{
			if(frmObject[obj].type == "checkbox")
				frmObject[obj].checked = eval(dataObject[obj]);
			else if(frmObject[obj].length>0 && frmObject[obj][0].type=="radio"){
				//if radio group -> mark the correct value 
					for(var i=0;i<frmObject[obj].length;i++){
						
						if( frmObject[obj][i].value == dataObject[obj].split("\r").join("").split("\"").join("") ){							
							frmObject[obj][i].checked = true;
							break;
						}
					}
			}else if(dataObject[obj].indexOf("\"")>-1){
				frmObject[obj].value = dataObject[obj].split("\"").join("");
			
			}else {
				
				frmObject[obj].value = eval(dataObject[obj]);
			}
		
				
			
		}catch(e){}
		
	}
	
	
}
//fill data object from form elements 
function fillObject(dataObject,frmObject){
	
	for(var obj in dataObject){		
		try{
			//alert(frmObject[obj].disabled)
			if(frmObject[obj].type == "checkbox")
				dataObject[obj] = (frmObject[obj].checked)?1:0;
			else if(frmObject[obj].getAttribute("isString")=="1" || frmObject[obj].isString=="1")
				dataObject[obj] = "\"" + frmObject[obj].value + "\""; 
			
			else if( frmObject[obj].value != null)				
				dataObject[obj] = frmObject[obj].value;
			
		}catch(e){
			
			
			}
		
	}
	return dataObject;
	
	
}

//copy port form to ports table display
function copyFormToColumn(){
	var frmObj = document.formAV
	if(!validateForm(frmObj,"AV")) return false;
	var portNumber= document.getElementById("portNumber").selectedIndex;
	//portsDataDisplay[portNumber]
	fillObject(portsDataDisplay[portNumber],frmObj);
	fillPortsTable(portNumber,portsDataDisplay[portNumber])
	//preColNumber
	
}

//fill port column in ports table view
//param:portNumber
//param:dataObject
function fillPortsTable(portNumber,dataObject){
	
	var rows = document.getElementById("portsTable").rows;
	var frmAV = document.formAV;
	var cell;
	var dataValue;
	var dataName;
	for(var i=1;i<rows.length;i++){
		cell = rows[i].cells[portNumber];
		dataName = rows[i].cells[0].getAttribute("ref");
		dataValue = "" + dataObject[dataName];
		//no input on form
		if(document.formAV[dataName]==null){
			cell.innerHTML = dataValue;
			continue;
		}
		//combo input
		if(document.formAV[dataName].type=="select-one"){
		var objTypes = null;	
		//since some data is hard coded and the other from config(e.g. encoders types)
		//see if data exists on config first.						
			try{
				objTypes = eval(dataName+"Types")
			}catch(e){}
		
			if(objTypes!=null){				
				//check if param is video standard
				if(objTypes == mpgVidResTypes){
					//set NTSC / PAL/HD
					
					switch(Number(dataObject["inVideoStandard"])){
						case 1:
							objTypes = mpgVidResPAL;
							break;
						case 2:
							objTypes = mpgVidResNTSC;
							break;
						case 3:
							objTypes = mpgVidResAN_HD;							
							break;
						default:
							break;
					}
				}
				//get label from config params
				cell.innerHTML = getLabel2(objTypes,dataValue);
			}else{
				//get label from the select element params
				cell.innerHTML = getLabel(document.formAV[dataName],dataValue)
			}
		//check box input
		}else if(document.formAV[dataName].type=="checkbox"){
			var str;
			switch(dataName){
				case "inLockToVsync":
					str=(dataValue==1)? "Locked":"UnLocked";
					break;
				case "portActiveEnable":
					str=(dataValue==1)? "Active":"InActive";
					break;
				default:
					str=(dataValue==1)? "Active":"InActive";
					break;
			}
			cell.innerHTML = str;
		//text input
		}else{
			if(dataValue.indexOf("\"")>-1)
				dataValue = dataValue.split("\"").join("");
			cell.innerHTML = dataValue;
		}
	}
}


//get the label attribute by givven value ---from dropdown object
function getLabel(selectObj,targetValue){
	//alert(selectObj.id + ":" +targetValue)
	for(var i=0;i<selectObj.childNodes.length;i++){
		if(selectObj.childNodes[i].nodeType==1){
			if(selectObj.childNodes[i].getAttribute("value")==targetValue){		
			//alert(selectObj.childNodes[i].firstChild.nodeValue)
				return selectObj.childNodes[i].firstChild.nodeValue;
			}
		}
	}
	return "";
}

//get the name(text) attribute by givven value ---from object config 
function getLabel2(selectObj,targetValue){
	for(var i=0;i<selectObj.length;i++){
		if(selectObj[i].value==targetValue){							
			return selectObj[i].name;
		}
	}
	return "";
}

//mark column selection
function markPortCol(colNumber){
	var rows = document.getElementById("portsTable").rows;
	var cell;
	for(var i=1;i<rows.length;i++){
		cell = rows[i].cells[preColNumber];
		cell.style.backgroundColor = '#FFFFFF';
		cell = rows[i].cells[colNumber];
		cell.style.backgroundColor = '#EBF6FF';
	}
	rows[0].cells[preColNumber].style.backgroundColor = '#F6F6F6';
	//rows[0].cells[preColNumber].style.color = '#000000'
	rows[0].cells[colNumber].style.backgroundColor = '#B2c2DB';
	//rows[0].cells[colNumber].style.color = '#F6F6F6';
	
	preColNumber = colNumber;
}

//mark column selection
function unMarkTable(tableName){
	var rows = document.getElementById(tableName).rows;
	var cell;
	for(var i=1;i<rows.length;i++){
		for(var j=0;j<rows[i].cells.length;j++){
			cell = rows[i].cells[j];
			cell.style.color = '#000000';
			cell.style.backgroundColor = '#FFFFFF';
		}		
	}	
}

function unMarkFormTable(tbl){	
	var rows = document.getElementById(tbl).rows;
//alert(tbl+":"+rows.length +" \n" + document.getElementById(tbl).innerHTML)	
	for(var i=0;i<rows.length;i++){
		rows[i].style.backgroundColor = '#FFFFFF';
	}	
	
}





//convert data object to param=value string;
function objectToPostString(dataObject){
	var retStr="";
	for(var obj in dataObject){
		retStr+= obj + "=" + dataObject[obj] + "\n";
		//alert(dataObject[obj])
	}
	return retStr;
}


//find match value in ports data -- used in form validation for checking uniqueness
/*param cIndex: current col, 
 *param paramName: target attribute parameter
 *param, targetStr: target seek string
 *param, namesArr: seek object names
 */
function findByValue(cIndex,paramName,targetStr,namesArr){
	var obj;
	for(var i=0;i<portsDataDisplay.length;i++){
		if(i==cIndex) continue;
		obj = portsDataDisplay[i];
		if(obj.portActiveEnable=="0") continue;
		for(var x=0;x<namesArr.length;x++){
			//alert(obj[namesArr[x]] + "  " +namesArr[x]+ "  "+x)
			if(obj[namesArr[x]].split("\"").join("") == targetStr){
				var retObject = new Object();
				retObject.portNum = i;
				retObject.attributeName = namesArr[x];
				return retObject;
				
			}
		}
	}
	return null;
	
}

//gets the selected value from a button group
function valButton(btn){
	if (btn){
		for (var i=0;i<btn.length; i++){
			if (btn[i].checked){
				return btn[i].value;
			}
		}
	}
	return "";
}


function markRow(e,is_cell){
	var color = "#D98C8C";
	
	if(e.parentElement) {
		if(e.parentElement.tagName=="SPAN")
			markRow(e.parentNode)
			//e.parentElement.firstChild.style.backgroundColor=color;
			
		else if(e.parentElement.tagName=="DIV")
			e.parentElement.style.backgroundColor=color;
		else if(is_cell && e.parentElement.tagName=="TD")
			e.parentElement.style.backgroundColor=color;
		else
			e.parentElement.parentElement.style.backgroundColor=color;
	}else{
		if(e.parentNode.tagName=="SPAN")
			markRow(e.parentNode)
		else if(e.parentNode.nodeName=="DIV")
			e.parentNode.style.backgroundColor=color;
		else if(is_cell && e.parentNode.tagName=="TD")
			e.parentNode.style.backgroundColor=color;
		else
			e.parentNode.parentNode.style.backgroundColor=color;
	}
	
}

/*validate forms
frmObj = the form element
type - the form type (av , maint , dmod..)
isPopup - a boolean indicate if the form is on a popup , need special handle for marking errors 
isCell -  a boolean indicate if in case of input error to mark the entier table row or just the cell
*/
function validateForm(frmObj,type,isPopup,isCell){
	
		unMarkTable("portsTable");
		unMarkTable("tableSPTS");
		unMarkFormTable("table"+type);
		document.getElementById("qamBandwidth_dynamic").style.backgroundColor = '#f7f7f7';
		
	
	var errors = '';
	var i,e,t,n,v,a;
	for(i=0; i < frmObj.elements.length; i++){
		e = frmObj.elements[i];
		if(e.optional || e.type=="button") continue;
		t = e.type;
		n = e.name;
		//alert(e.alias)
		a = e.alias;
		v = e.value = trim(e.value);
		
		var fColor = "#FF0000"
		if(t == 'text'){
			
			if(e.allowEmpty!=true && isEmpty(v)){
				errors += n+' cannot be empty.\n'; 
					markRow(e,isCell);
					 continue;
		  	}
			if(e.isTime){
				if(!isTime(v)){
					errors += 'time format is invalid';
					//mark on form
					markRow(e,isCell);
					continue;
				}				
			}
			if(e.isInteger){
				if(!isInteger(v)){
					errors += 'Must be Integer';
					//mark on form
					markRow(e,isCell);
					continue;
				}				
			}
			
			if(e.isUnique != null){
				var currentPort = document.getElementById("portNumber").selectedIndex; 
				var retObject =findByValue(currentPort,n,v,e.isUnique);
        		if(retObject != null){
					//mark in table
					var rows = document.getElementById("portsTable").rows;
					var cell;
					for(var x=1;x<rows.length;x++){						
						if(rows[x].cells[0].getAttribute("ref")== retObject.attributeName){
							cell = rows[x].cells[retObject.portNum];
							cell.style.color = fColor;						
						}
					}
					
          			errors += a+' cannot match ' + a + ' on port' + (retObject.portNum+1) + '.\n';
					//mark on form
					markRow(e,isCell);
					 continue;
        		}
      		}
			if(e.isMatch != null){
        		if(isMatch(v, e.isMatch)){
          			errors += a+' cannot match ' + e.isMatch.name + '.\n'; 
					markRow(e,isCell);
					 continue;
        		}
      		}
			
		  	if(e.isLengthBetween != null){
				
          		var min = e.isLengthBetween[0];
          		var max = e.isLengthBetween[1];
          		
				if(!isLengthBetween(v,min,max)){
          			errors += a+' cannot contain less than '+min+' or more than '+max+' characters.\n'; 
					markRow(e,isCell);
					 continue;
				}
			}
			if(e.isValidIP != null){
          		
          		if(!isIP(v)){
          			errors += v+' is not a valid IP.\n'; 
					markRow(e,isCell);
					 continue;
				}
			}
		  	if(e.isValueBetween != null){
				if(!isNumeric(v)){
         			errors += n+' can only contain characters 0-9.\n'; 
					markRow(e,isCell);
					 continue;
        		}
          		var min = e.isValueBetween[0];
          		var max = e.isValueBetween[1];
				if(e.isDivid != null){
					if(!isDivid(v,e.isDivid)){
          				errors += a+' cannot be less than '+min+' or more than '+max+' in '+ e.isDivid +' steps.\n'; 
					markRow(e,isCell);
					 continue;
					}
				}
				
          		if(!isValueBetween(v,min,max)){
          			errors += a+' cannot be less than '+min+' or more than '+max+'.\n'; 
					markRow(e,isCell);
					//e.parentElement.parentElement.style.color = color;
					 continue;
				}
			}
		}
	}
	
	if(errors!=''){		
		if(!isPopup){
			showPopWin("<p>Please Correct The Values That Are Marked In Red.</p>", 250, 120, null,true,"Warning");
		}else
			popFormSetMessage("Please Correct The Values That Are Marked In Red.");
		return false;
	}else{
		return true;
	}
}

function trim(str){
  var result = str;
  var re = /\s/g
  if(str.search(re) != -1){
    result = str.replace(re, '');
  }
  return result;
}

function isLengthBetween(str, min, max){
  return (str.length >= min)&&(str.length <= max);
}

function isValueBetween(str, min, max){
  return (eval(str) >= min)&&(eval(str) <= max);
}

function isNumeric(str){
  //var re = /[\D]/g
  //if (re.test(str)) return false;
  //return true;
  return !isNaN(str)
}

function isDivid(n1,n2){
	return (n1/n2==parseInt(n1/n2))
}

function isEmpty(str){
  return (str == null) || (str.length == 0);
}

function isMatch(str, arrValue){
	for(var i=0;i< arrValue.length;i++)
  		if (str==arrValue[i].value)
			return true;
	return false;	
}

function isTime (timeValue) {
	
	var timePattern = /^(\d{2,2})\:(\d{2,2})$/;
	var timeArray = timeValue.match(timePattern);
	
	if (timeArray == null)
		return false;
	if(timeArray[1]>23)
		return false;
	if(timeArray[2]>59)
		return false;
	
	return true;
}

function isIP (IPvalue) {
	
	var ipPattern = /^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/;
	var ipArray = IPvalue.match(ipPattern);
	
	if (ipArray == null)
		return false;
	else {
		for (i = 1; i < 5; i++) {
			thisSegment = ipArray[i];			
			if (thisSegment > 255) {
				return false;
			}
	   	}
	}
	return true;
}

function isInteger(number){
	for (i=0; i < number.length; i++){
			if (number.charAt(i)==".")
				return false;
	}
	return true;
}

function loadLog(){
	
	showPopWin("<p>Loading File</p>", 250, 120, null,null,"Info.",true);
	doGetRequest(document.getElementById("txtURL").value,handleLoadLog)
}

function handleLoadLog(){
	var responseData = checkRequestStatus();
	if(responseData==null) return;
	document.getElementById("logContent").value = responseData;
	hidePopWin();
	
}

function copyObject(obj){
	var newObject = new Object();
	for (var att in obj)
		newObject[att] = obj[att];	
	return newObject;
}


