// JavaScript Document

var portsSPTSData = new Object();



function getGbitPortData(){
	showPopWin("<p>DVIS Loading Configuration ..<br> Please wait.</p>", 250, 120, null,null,"Info.",true);
	doGetRequest(serviceURL+settingsFolder+"gbitport.ini",handleGbitPortData);	
}

function handleGbitPortData(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	gbitPortData = doParse(responseData);
	var frm = document.forms["formIP_OUT"];	
	fillForm(frm,gbitPortData);
	set_IPOUTPUT_FecFields(frm.rtpEnableFec);
	ipDHCP_changeState(frm.EnableDHCP);

	doPostRequest(postURL + "?get_sfp_hw_params","",handleSFP_HW_Data);
}

function handleSFP_HW_Data(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	var tmpData = doParse(responseData);
	fillForm(document.forms["formSFP_HW"],tmpData);
	//Single Program TS , check box
	//document.forms["formIP_OUT"].muxSPTSEnable.value = profileData["muxSPTSEnable"];
	//document.forms["formIP_OUT"].muxSPTSEnable.checked = (profileData["muxSPTSEnable"] == "1")? true:false;
	handleMuxSPTSEnable_change(document.forms["formIP_OUT"].muxSPTSEnable)
	
	getSPTSdata();
	
}



function handleGbitSubmit(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	showPopWin("<p>DVIS Settings Successfully Updated.</p>", 250, 120, null,true,"Info.");
}

function set_IPOUTPUT_FecFields(el){
	var elState = el.checked;
	el.form.rtpFecLParam.disabled = !elState;
	el.form.rtpFecDParam.disabled = !elState;
	el.form.rtpColFecPort.disabled = !elState;
	el.form.rtpRowFecPort.disabled = !elState;
}

function ipDHCP_changeState(el){
	var frm = el.form;
	frm.udpHostSubnetAddr0.disabled = el.checked;
	frm.udpHostSubnetAddr1.disabled = el.checked;
	frm.udpHostSubnetAddr2.disabled = el.checked;
	frm.udpHostSubnetAddr3.disabled = el.checked;
	frm.udpHostIpAddr0.disabled = el.checked;
	frm.udpHostIpAddr1.disabled = el.checked;
	frm.udpHostIpAddr2.disabled = el.checked;
	frm.udpHostIpAddr3.disabled = el.checked;
}



//// ________ SPTS _________________//////////


function getSPTSdata(){
	portNum = 1;
	doGetRequest(serviceURL+settingsFolder+"port"+(portNum-1)+"/"+"SPTSport.ini",handleSPTSdata);	
	
}
//loop get SPTS data request
function handleSPTSdata(){
	var responseData = checkRequestStatus();	
	if(responseData==null) return;
	//parse and store data
	var tmpObj = doParse(responseData);
	portsSPTSData[portNum-1] = tmpObj;
	
	//fill SPTS table
	tmpObj = new Object();
	for(var item in portsSPTSData[portNum-1]){
		tmpObj[item + "_" + (portNum)] = portsSPTSData[portNum-1][item]
	}
	tmpObj["name_" + portNum] = portsData[portNum-1].progName;
	fillForm(document.forms["SPTSform"],tmpObj);
	if(portNum<portCount){
		portNum++				
		doGetRequest(serviceURL+settingsFolder+"port"+(portNum-1)+"/"+"SPTSport.ini",handleSPTSdata);
	}else{		
		portNum =1;
		hidePopWin();
		
	}
}


function handleMuxSPTSEnable_change(el){
	var state = el.checked;
	var frm = document.forms["formIP_OUT"];
	enableSPTS(state);
	frm.udpDestIpAddr0.disabled = state;
	frm.udpDestIpAddr1.disabled = state;
	frm.udpDestIpAddr2.disabled = state;
	frm.udpDestIpAddr3.disabled = state;
	frm.udpTxDestPort.disabled = state;
	frm.multicast.disabled = state;
	frm.rtpEnableFec.disabled = state;
	frm.rtpColFecPort.disabled = state;
	frm.rtpRowFecPort.disabled = state;
	frm.tsoutEnableCBR.disabled = state;
	frm.tsoutCBR.disabled = state;
	
	frm.rtpFecLParam.disabled = !state;
	frm.rtpFecDParam.disabled = !state;
	
	
}

function enableSPTS(state){
	
	
	var frm = document.forms["SPTSform"];
	var currentState;
	for(var i=0;i<portCount;i++){
		if(eval(portsData[i].portActiveEnable)== 0 || 
				portsData[i].encoderType == encoderTypes[0] ||
				portsData[i].encoderType == encoderTypes[4] ||
				portsData[i].encoderType == encoderTypes[5] 
				)
			currentState = false
		else
			currentState = state
		frm["udpDestIpAddr0_"+(i+1)].disabled = !currentState;
		frm["udpDestIpAddr1_"+(i+1)].disabled = !currentState;
		frm["udpDestIpAddr2_"+(i+1)].disabled = !currentState;
		frm["udpDestIpAddr3_"+(i+1)].disabled = !currentState;
		frm["udpTxDestPort_"+(i+1)].disabled = !currentState;
		frm["multicast_"+(i+1)].disabled = !currentState;
		frm["rtpEnableFec_"+(i+1)].disabled = !currentState;
		enableRtpFec(frm["rtpEnableFec_"+ (i+1)],i+1);
	}
	
}


function enableRtpFec(el,index){
	var state = el.checked;
	var frm = document.forms["SPTSform"];
	frm["rtpColFecPort_"+index].disabled = !state;
	frm["rtpRowFecPort_"+index].disabled = !state;
	
}


function getSPTSPostData(){
	var str="";
	var tmp;
	var arg;
	var tmpObj;
	for(var i=0;i<portCount;i++){
	
		tmpObj = new Object();
		for(arg in portsSPTSData[i]){
			tmpObj[arg + "_" + (i+1)] = portsSPTSData[i][arg]
		}
		fillObject(tmpObj,document.forms["SPTSform"]);
		
		for(arg in tmpObj){
			portsSPTSData[i][arg.split("_")[0]] = tmpObj[arg];
		}
		str += "\n[SPTSport " + (i+1) + "]\n";		
		str += "[general]\n" ;
		tmp = objectToPostString(portsSPTSData[i]);
		tmp = tmp.replace("udpDestIpAddr","[udp]\nudpDestIpAddr");
		tmp = tmp.replace("rtpEnableFec","[rtp_fec]\nrtpEnableFec");
		str += tmp; 
	}
	
	return str;
	
}

function validateIP_Out(){
	
	var frm = document.forms["formIP_OUT"];
	if(frm.rtpRowFecPort.value == frm.rtpColFecPort.value){
		markRow(frm.rtpRowFecPort);
		markRow(frm.rtpColFecPort);
		return false;
	}
	if(!frm.muxSPTSEnable.checked)
		return true; 
	frm = document.forms["SPTSform"];
	if(!validateForm(frm,"SPTS",false,true)){
		return false;	
	}
	
	//unique port check
	var destIP_Arr = new Object();
	var destPorts_Arr = new Object();
	var tmpIP;
	var x;
	var i;
	var el1,el2,el3;
	var retValue = true;
	for(i=0;i<portCount;i++){
		if(eval(portsData[i].portActiveEnable)== 0 ||
				portsData[i].encoderType == encoderTypes[0] ||
				portsData[i].encoderType == encoderTypes[4] ||
				portsData[i].encoderType == encoderTypes[5]) continue;
		//ip is the unique key of destIP_Arr
		tmpIP = frm["udpDestIpAddr0_"+(i+1)].value+"."+frm["udpDestIpAddr1_"+(i+1)].value+"."+frm["udpDestIpAddr2_"+(i+1)].value+"."+frm["udpDestIpAddr3_"+(i+1)].value;
		if (destIP_Arr[tmpIP] == null)
			destIP_Arr[tmpIP] = new Array();
		//push argument appearance index
		destIP_Arr[tmpIP].push(i+1);
	}
	//loop all unique ip
	for (x in destIP_Arr){
		destPorts_Arr = new Object();
		//loop all appearance indexes
		for(i=0;i<destIP_Arr[x].length;i++){
			el1 = frm["udpTxDestPort_" + destIP_Arr[x][i]];			
			if(destPorts_Arr[el1.value] != null){
				//mark current
				markRow(el1,true);
				//mark first appearance
				markRow( frm["udpTxDestPort_" + destPorts_Arr[el1.value]],true);
				retValue = false;
			}else{
				destPorts_Arr[el1.value] = destIP_Arr[x][i];
			}
			
			if(frm["rtpEnableFec_" + destIP_Arr[x][i]].checked){
				el2 = frm["rtpColFecPort_" + destIP_Arr[x][i]];
				el3 = frm["rtpRowFecPort_" + destIP_Arr[x][i]];
				if(destPorts_Arr[el2.value] != null){
					markRow(el2,true);
					markRow( frm["rtpColFecPort_" + destPorts_Arr[el1.value]],true);
					retValue = false;
				}else{
					destPorts_Arr[el2.value] = destIP_Arr[x][i];
				}
				if(destPorts_Arr[el3.value] != null){
					markRow(el3,true);
					markRow( frm["rtpRowFecPort_" + destPorts_Arr[el1.value]],true);
					retValue = false;
				}else{
					destPorts_Arr[el3.value] = destIP_Arr[x][i];
				}

			}
			
		}
	}
	
	return retValue;
	
	
}


